package com.easemob.helpdeskdemo.receiver;

import android.content.Context;
import android.content.Intent;

import com.easemob.helpdeskdemo.utils.Calling;
import com.easemob.veckit.VECKitCalling;
import com.hyphenate.chat.AgoraMessage;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.IBroadcastCallback;
import com.hyphenate.helpdesk.util.Log;


/**
 * Created by liyuzhao on 11/01/2017.
 */

public class CallReceiver implements IBroadcastCallback {
    boolean mIsOnLine;
    @Override
    public void onReceive(Context context, Intent intent) {
        if (!ChatClient.getInstance().isLoggedInBefore()){
            return;
        }
        String action = intent.getAction();
        Log.e("CustomBroadcastManager", "onReceive action = "+action);
        if ("calling.state".equals(action)){
            // 防止正在通话中，又新发来视频请求，isOnLine代表是否接通通话中
            mIsOnLine = intent.getBooleanExtra("state", false);
        }else {
            //call type
            String type = intent.getStringExtra("type");
            boolean isVecVideo = intent.getBooleanExtra("isVecVideo", false);
            if ("video".equals(type)){// video call
                if (!mIsOnLine){
                    if (isVecVideo){
                        // 新版vec视频客服
                        VECKitCalling.callingResponse(context, intent);
                    }else {
                        // 旧版在线视频
                        Calling.callingResponse(context, intent);
                    }
                }
            }else if (AgoraMessage.TYPE_ENQUIRYINVITE.equalsIgnoreCase(type)){
                // 满意度评价
                VECKitCalling.callingEvaluation(context, intent.getStringExtra("from"), intent.getStringExtra("content"));
            }
            Log.e("CustomBroadcastManager", "onReceive type = "+type);
        }
        Log.e("CustomBroadcastManager", "onReceive mIsOnLine = "+mIsOnLine);
    }
}
