/**
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved.
 * <p/>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.easemob.helpdeskdemo.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.PowerManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.Display;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;

import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;

import com.easemob.bottomnavigation.BottomNavigation;
import com.easemob.bottomnavigation.OnBottomNavigationSelectedListener;
import com.easemob.helpdeskdemo.Constant;
import com.easemob.helpdeskdemo.DemoHelper;
import com.easemob.helpdeskdemo.DemoMessageHelper;
import com.easemob.helpdeskdemo.HMSPushHelper;
import com.easemob.helpdeskdemo.HONORPushHelper;
import com.easemob.helpdeskdemo.Preferences;
import com.easemob.helpdeskdemo.R;
import com.hyphenate.agora.FunctionIconItem;
import com.hyphenate.chat.AgoraMessage;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.ChatManager;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.FlatFunctionUtils;
import com.hyphenate.chat.Message;
import com.hyphenate.helpdesk.Error;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.easeui.permission.FloatWindowManager;
import com.hyphenate.helpdesk.easeui.runtimepermission.PermissionsManager;
import com.hyphenate.helpdesk.easeui.runtimepermission.PermissionsResultAction;
import com.hyphenate.helpdesk.easeui.util.StatusBarUtils;
import com.hyphenate.helpdesk.model.ContentFactory;
import com.hyphenate.helpdesk.model.VisitorInfo;
import com.hyphenate.helpdesk.util.AESUtils;
import com.hyphenate.helpdesk.util.Log;
import com.hyphenate.util.EasyUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

public class MainActivity extends DemoBaseActivity implements OnBottomNavigationSelectedListener {

    private final static String TAG = "MainActivity";
    private Fragment shopFragment = null;
    private Fragment settingFragment = null;
    private Fragment ticketListFragment = null;
    private Fragment conversationsFragment = null;
    private Fragment[] fragments;
    private int currentTabIndex = 0;
    private MyConnectionListener connectionListener = null;
    private BottomNavigation mBottomNav;

    private View mContent;
    private WindowManager mWm;
    private Point mPoint = new Point();

    private final ViewTreeObserver.OnGlobalLayoutListener mOnGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener() {
        @Override
        public void onGlobalLayout() {
            DemoHelper.sNavHeight = getNav(mWm, mContent, mPoint);
            mContent.getViewTreeObserver().removeOnGlobalLayoutListener(mOnGlobalLayoutListener);
        }
    };

    private int getNav(WindowManager wm, View content, Point point) {
        Display display = wm.getDefaultDisplay();
        display.getRealSize(point);
        if (content.getBottom() == 0) {
            return 0;
        }

        return point.y - content.getBottom();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            String packageName = getPackageName();
            PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
            try {
                assert pm != null;
                if (!pm.isIgnoringBatteryOptimizations(packageName)) {
                    Intent intent = new Intent();
                    intent.setAction(Settings.ACTION_REQUEST_IGNORE_BATTERY_OPTIMIZATIONS);
                    intent.setData(Uri.parse("package:" + packageName));
                    startActivity(intent);
                }
            } catch (Exception ignored) {
                //锤子手机会报找不到这个Activity
                //android.content.ActivityNotFoundException: No Activity found to handle Intent { act=android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS dat=package:com.easemob.helpdeskdemo }

            }

        }

        mContent = getWindow().getDecorView().findViewById(android.R.id.content);
        mWm = (WindowManager) getSystemService(Context.WINDOW_SERVICE);
        mContent.getViewTreeObserver().addOnGlobalLayoutListener(mOnGlobalLayoutListener);

        // 获取可用功能
        getTenantIdFunctionIcons();

        setContentView(R.layout.em_activity_main);
        String customerAccount = Preferences.getInstance().getCustomerAccount();
        /*AgoraMessage.newAgoraMessage().setVecImServiceNumber("kefuchannelimid_154337");
        ChatClient.getInstance().changeConfigId("0abe1558-8113-403b-a677-dc9312e91c10");*/
        /*if (!TextUtils.isEmpty(customerAccount)) {
            // AgoraMessage.newAgoraMessage().setVecImServiceNumber("kefuchannelimid_392654");
            AgoraMessage.newAgoraMessage().setVecImServiceNumber(customerAccount);
            AgoraMessage.newAgoraMessage().setCecImServiceNumber(customerAccount);
        }*/

        FragmentTransaction trx = getSupportFragmentManager().beginTransaction();

        if (savedInstanceState != null) {
            currentTabIndex = savedInstanceState.getInt("selectedIndex", 0);
            //Activity被杀死的时候，有些情况Fragment不被销毁
            if (shopFragment == null) {
                shopFragment = getSupportFragmentManager().findFragmentByTag("shopFragment");
                settingFragment = getSupportFragmentManager().findFragmentByTag("settingFragment");
                ticketListFragment = getSupportFragmentManager().findFragmentByTag("ticketListFragment");
                conversationsFragment = getSupportFragmentManager().findFragmentByTag("conversationsFragment");
            }
        }

        if (shopFragment == null) {
            shopFragment = new ShopFragment();
            trx.add(R.id.fragment_container, shopFragment, "shopFragment");
        }

        if (ticketListFragment == null) {
            ticketListFragment = new TicketListFragment();
            trx.add(R.id.fragment_container, ticketListFragment, "ticketListFragment");
        }

        if (conversationsFragment == null) {
            conversationsFragment = new ConversationListFragment();
            trx.add(R.id.fragment_container, conversationsFragment, "conversationsFragment");
        }

        if (settingFragment == null) {
            settingFragment = new SettingFragment();
            trx.add(R.id.fragment_container, settingFragment, "settingFragment");
        }

        fragments = new Fragment[]{shopFragment, ticketListFragment, conversationsFragment, settingFragment};

        // 把shopFragment设为选中状态
        trx.hide(settingFragment)
                .hide(ticketListFragment)
                .hide(conversationsFragment)
                .hide(shopFragment)
                .show(fragments[currentTabIndex])
                .commit();


        mBottomNav = $(R.id.bottom_navigation);
        mBottomNav.setBottomNavigationSelectedListener(this);
        //注册一个监听连接状态的listener
        connectionListener = new MyConnectionListener();
        ChatClient.getInstance().addConnectionListener(connectionListener);
        //6.0运行时权限处理，target api设成23时，demo这里做的比较简单，直接请求所有需要的运行时权限
        requestPermissions();


        // 检查华为推送服务
        HMSPushHelper.getInstance().getHMSToken(this);
        //检查荣耀推送
        HONORPushHelper.getInstance().getHonorToken(this);

        /*QueueIdentityInfo info1 = ContentFactory.createQueueIdentityInfo(null);
        info1.queueName(queueName); // 技能组名称*/


        /*TextView textView1 = findViewById(R.id.textView1);
        textView1.setText("http://www.baidu.com");

        TextView textView2 = findViewById(R.id.textView2);
        textView2.setText(Html.fromHtml("<a href=\"http://www.baidu.com\">http://www.baidu.com</a>"));
        textView2.setMovementMethod(LinkMovementMethod.getInstance());*/


        // ChatClient.getInstance().chatManager().getConversation();
        // ChatClient.getInstance().logout();
        // Chaient.getInstance().logout();
        // ChatClient.getInstance().chatManager().getAllConversations()

        /*ChatClient.getInstance().leaveMsgManager().getWorkStatus(Preferences.getInstance().getCustomerAccount(), new ValueCallBack<String>() {
            @Override
            public void onSuccess(String value) {
            }

            @Override
            public void onError(int error, String errorMsg) {
            }
        });*/



        /*ChatClient.getInstance().chatManager().getEnterpriseWelcome(new ValueCallBack<String>() {
            @Override
            public void onSuccess(String value) {
                Log.e(TAG,"value = "+value);
            }

            @Override
            public void onError(int error, String errorMsg) {
                Log.e(TAG,"errorMsg = "+errorMsg);
         }
        });*/


        //AgoraMessage.newAgoraMessage().registerVecBroadcast(this);


        // mr8kcsy4s0f28hs

        /*Conversation name = ChatClient.getInstance().chatManager().getConversation("MR8KCSY4S0F28HS");
        List<Message> msgs = name.getAllMessages();
        Log.e("LoginActivity", "si= "+msgs.size());*/


        // 给新版vec聊天设置昵称
        // VecConfig.newVecConfig().setUserName("测试");

        DemoMessageHelper.createVisitorInfo();

    }

    @TargetApi(35)
    private void hideSystemBars() {
        // 启用沉浸式模式
        WindowInsetsControllerCompat windowInsetsController = WindowCompat.getInsetsController(getWindow(), getWindow().getDecorView());
        windowInsetsController.setAppearanceLightStatusBars(true);// 浅色图标（深色背景）‌:ml-citation{ref="6,7" data="citationList"}
        WindowCompat.setDecorFitsSystemWindows(getWindow(), false);
        getWindow().setStatusBarContrastEnforced(false);
        getWindow().setStatusBarColor(Color.TRANSPARENT);
        getWindow().setNavigationBarContrastEnforced(false);
        getWindow().setNavigationBarColor(Color.TRANSPARENT);
        windowInsetsController.setSystemBarsBehavior(WindowInsetsControllerCompat.BEHAVIOR_SHOW_TRANSIENT_BARS_BY_SWIPE);
        windowInsetsController.hide(WindowInsetsCompat.Type.navigationBars());
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (!FloatWindowManager.getInstance().checkPermission(this)) {
            FloatWindowManager.getInstance().applyPermission(this);
        }
    }


    private void getTenantIdFunctionIcons() {
        // 动态获取功能按钮，在视频页面使用到
        AgoraMessage.asyncGetTenantIdFunctionIcons(ChatClient.getInstance().tenantId(), new ValueCallBack<List<FunctionIconItem>>() {
            @Override
            public void onSuccess(List<FunctionIconItem> value) {
                FlatFunctionUtils.get().setIconItems(value);
            }

            @Override
            public void onError(int error, String errorMsg) {

            }
        });
    }

    @TargetApi(23)
    private void requestPermissions() {
        PermissionsManager.getInstance().requestAllManifestPermissionsIfNecessary(this, new PermissionsResultAction() {
            @Override
            public void onGranted() {
            }

            @Override
            public void onDenied(String permission) {
            }
        });
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionsManager.getInstance().notifyPermissionsChange(permissions, grantResults);

    }


    @Override
    public void onValueSelected(int index) {
        if (currentTabIndex != index) {
            FragmentTransaction trx = getSupportFragmentManager()
                    .beginTransaction();
            trx.hide(fragments[currentTabIndex]);
            if (!fragments[index].isAdded()) {
                trx.add(R.id.fragment_container, fragments[index]);
            }
            trx.show(fragments[index]).commitAllowingStateLoss();
        }
        currentTabIndex = index;
    }

    public class MyConnectionListener implements ChatClient.ConnectionListener {

        @Override
        public void onConnected() {

        }

        @Override
        public void onDisconnected(final int errorCode) {
            if (errorCode == Error.USER_NOT_FOUND || errorCode == Error.USER_LOGIN_ANOTHER_DEVICE
                    || errorCode == Error.USER_AUTHENTICATION_FAILED
                    || errorCode == Error.USER_REMOVED) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        //demo中为了演示当用户被删除或者修改密码后验证失败,跳出会话界面
                        //正常APP应该跳到登录界面或者其他操作
                        if (ChatActivity.instance != null) {
                            ChatActivity.instance.finish();
                        }
                        ChatClient.getInstance().logout(false, null);
                    }
                });
            }
        }

    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            moveTaskToBack(false);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void contactCustomer(View view) {
        switch (view.getId()) {
            case R.id.ll_setting_list_customer:
                Intent intent = new Intent();
                intent.setClass(MainActivity.this, LoginActivity.class);
                intent.putExtra(Constant.MESSAGE_TO_INTENT_EXTRA, Constant.MESSAGE_TO_DEFAULT);
                startActivity(intent);
                break;
            default:
                break;
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (connectionListener != null) {
            ChatClient.getInstance().removeConnectionListener(connectionListener);
        }
        FlatFunctionUtils.get().clear();
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (ChatClient.getInstance().chatManager() != null){
            DemoHelper.getInstance().pushActivity(this);
            ChatClient.getInstance().chatManager().addMessageListener(messageListener);
            DemoHelper.getInstance().showNotificationPermissionDialog();
            Log.e("ppppppppppp","onResume isConnected = "+ EMClient.getInstance().isConnected());
            Log.e("ppppppppppp","onResume isLoggedIn = "+ EMClient.getInstance().isLoggedIn());
            Log.e("ppppppppppp","onResume isLoggedInBefore = "+ ChatClient.getInstance().isLoggedInBefore());
            Log.e("ppppppppppp","onResume EMClient.isLoggedInBefore = "+ EMClient.getInstance().isLoggedInBefore());
        }


        /*ChatClient.getInstance().chatManager().asyncVisitorId("kefuchannelimid_612070", new ValueCallBack<String>() {
            @Override
            public void onSuccess(String value) {
                Log.e("uuuuuuuuuuuu","asyncVisitorId = "+value);

            }

            @Override
            public void onError(int error, String errorMsg) {
                Log.e("aaaaaaaaaa","asyncVisitorId errorMsg = "+errorMsg);
            }
        });*/
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("selectedIndex", currentTabIndex);
    }

    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        currentTabIndex = savedInstanceState.getInt("selectedIndex", 0);
    }

    @Override
    protected void onStop() {
        super.onStop();
        ChatClient.getInstance().chatManager().removeMessageListener(messageListener);
        DemoHelper.getInstance().popActivity(this);

    }

    ChatManager.MessageListener messageListener = new ChatManager.MessageListener() {

        @Override
        public void onMessage(final List<Message> msgs) {

            runOnUiThread(new Runnable() {
                @Override
                public void run() {

                    // 未读数可以显示在UI上
                    // int unreadMsgCount = ChatClient.getInstance().chatManager().getUnreadMsgsCount();
                    if (EasyUtils.isAppRunningForeground(MainActivity.this)) {
                        DemoHelper.getInstance().getNotifier().onNewMesg(msgs);
                    }


                    if (conversationsFragment != null) {
                        ((ConversationListFragment) conversationsFragment).refresh();
                    }
                }
            });
        }

        @Override
        public void onCmdMessage(List<Message> msgs) {

        }

        @Override
        public void onMessageStatusUpdate() {

        }

        @Override
        public void onMessageSent() {

        }
    };
}

