package com.easemob.helpdeskdemo.utils;

import android.content.Context;
import android.content.Intent;
import android.net.IpSecManager;
import android.text.TextUtils;

import com.easemob.helpdeskdemo.R;
import com.easemob.helpdeskdemo.service.VideoCallWindowService;
import com.easemob.helpdeskdemo.ui.CallActivity;
import com.hyphenate.chat.AgoraMessage;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.VecConfig;
import com.hyphenate.helpdesk.easeui.permission.FloatWindowManager;
import com.hyphenate.helpdesk.util.Log;

public class Calling {
    // 主动
    public static void callingRequest(Context context, String serviceNumber){

        if (TextUtils.isEmpty(serviceNumber)) {
            throw new RuntimeException("serviceNumber is null.");
        }

        ChatClient.getInstance().callManager().callVideo(context.getString(R.string.em_chat_invite_video_call), serviceNumber);
        if (FloatWindowManager.getInstance().checkPermission(context)){
            VideoCallWindowService.show(context, serviceNumber);
        }else {
            CallActivity.show(context, serviceNumber);
        }
    }

    /**
     * 点击训前引导页面条目 发起视频
     * @param context 上下文、
     * @param serviceNumber im服务号
     */
    public static void callingRequestFromClickGuideMenu(Context context, String serviceNumber){
        if (TextUtils.isEmpty(serviceNumber)) {
            throw new RuntimeException("serviceNumber is null.");
        }

        if (FloatWindowManager.getInstance().checkPermission(context)){
            VideoCallWindowService.show(context, serviceNumber);
        }else {
            CallActivity.show(context, serviceNumber);
        }
    }


    // 被动
    public static void callingResponse(Context context, Intent intent){
        if (FloatWindowManager.getInstance().checkPermission(context)){
            VideoCallWindowService.show(context, intent);
        }else {
            CallActivity.show(context, intent);
        }
    }
}
