package com.easemob.helpdeskdemo.utils;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.Nullable;

import com.easemob.helpdeskdemo.Preferences;
import com.easemob.helpdeskdemo.R;
import com.easemob.veckit.VECKitCalling;
import com.easemob.veckit.utils.VecKitOptions;
import com.easemob.veckit.utils.WaitPageUtils;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.Message;

public class TestActivity extends Activity implements WaitPageUtils.IWaitPageUtils{

    private TextView mWaitTv;

    public static void startTestActivity(Activity activity){
        Intent intent = new Intent(activity, TestActivity.class);
        activity.startActivity(intent);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_test);
        mWaitTv = findViewById(R.id.waitTv);
        mWaitTv.setText("发起视频邀请，等待排队");


        Button button = findViewById(R.id.button);
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String imService = Preferences.getInstance().getCustomerAccount();
                String configId = ChatClient.getInstance().getConfigId();
                if (TextUtils.isEmpty(imService)){
                    Toast.makeText(TestActivity.this, "请先扫码关联VEC视频客服，重新登录！", Toast.LENGTH_LONG).show();
                    return;
                }
                WaitPageUtils.newWaitPageUtils().sendVideo(TestActivity.this,
                        imService, configId);
            }
        });

        Button end = findViewById(R.id.end);
        end.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                WaitPageUtils.newWaitPageUtils().sendEndCall();
            }
        });

        WaitPageUtils.newWaitPageUtils().register(this);

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        WaitPageUtils.newWaitPageUtils().unRegister();
    }

    @Override
    public void onWait(boolean isWaiting, String visitorWaitingMsg, String session) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mWaitTv.setText(visitorWaitingMsg);
            }
        });
    }

    @Override
    public void onWaitTimeout(Message message) {

    }

    @Override
    public void onAgentAnswerResponse() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                finish();
            }
        });
    }

    @Override
    public void onAgentRejectBreakOff() {

        VecKitOptions.getVecKitOptions().setShowCallingView(true);
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mWaitTv.setText("坐席拒接视频邀请！");
            }
        });
    }
}
