package com.hyphenate.helpdesk.easeui.util;

import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;

public class StatusBarUtils {

    /**
     * 设置沉浸式状态栏（适配 fitsSystemWindows）
     *
     * @param activity   目标 Activity
     * @param isDarkIcon 状态栏图标是否为深色模式
     */
    public static void setImmersiveStatusBar(Activity activity, boolean isDarkIcon) {
        Window window = activity.getWindow();

        // 透明化状态栏（分版本处理）
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.UPSIDE_DOWN_CAKE) {
            WindowInsetsControllerCompat windowInsetsController = WindowCompat.getInsetsController(window, window.getDecorView());
            windowInsetsController.setAppearanceLightStatusBars(true);// 浅色图标（深色背景）‌:ml-citation{ref="6,7" data="citationList"}
            WindowCompat.setDecorFitsSystemWindows(window, false);
            window.setStatusBarContrastEnforced(false);
            window.setStatusBarColor(Color.TRANSPARENT);
            window.setNavigationBarContrastEnforced(false);
            window.setNavigationBarColor(Color.TRANSPARENT);
            windowInsetsController.setSystemBarsBehavior(WindowInsetsControllerCompat.BEHAVIOR_SHOW_TRANSIENT_BARS_BY_SWIPE);
            windowInsetsController.hide(WindowInsetsCompat.Type.navigationBars());
        } else {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
                window.setStatusBarColor(Color.TRANSPARENT);
            } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                window.addFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            }

            // 允许布局延伸到状态栏
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                View decorView = window.getDecorView();
                int systemUiVisibility = decorView.getSystemUiVisibility();
                systemUiVisibility |= View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN;
                decorView.setSystemUiVisibility(systemUiVisibility);
            }

            // 动态调整状态栏图标颜色
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                View decorView = window.getDecorView();
                int flags = decorView.getSystemUiVisibility();
                if (isDarkIcon) {
                    flags |= View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;
                } else {
                    flags &= ~View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;
                }
                decorView.setSystemUiVisibility(flags);
            }

            // 处理 fitsSystemWindows 的 Padding 问题
            View rootView = window.getDecorView().findViewById(android.R.id.content);
            ViewCompat.setOnApplyWindowInsetsListener(rootView, (v, insets) -> {
                // 移除顶部 Padding（沉浸式适配）
                v.setPadding(
                        v.getPaddingLeft(),
                        0, // 顶部 Padding 置零
                        v.getPaddingRight(),
                        0
                );
                return insets;
            });
        }
    }
}

