package com.hyphenate.helpdesk.easeui.util;


import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.hardware.Camera;
import android.hardware.Camera.Parameters;
import android.hardware.Camera.Size;
import android.os.Build;
import android.os.Build.VERSION_CODES;
import android.os.StrictMode;
import android.text.TextUtils;
import android.util.TypedValue;

import com.hyphenate.agora.ZuoXiSendRequestObj;
import com.hyphenate.chat.Message;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.helpdesk.easeui.ui.ImageGridActivity;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Comparator;
import java.util.List;

public class Utils {

	private Utils() {
	}

	@SuppressLint("NewApi")
	public static void enableStrictMode() {
		if(Utils.hasGingerbread())
		{
			StrictMode.ThreadPolicy.Builder threadPolicyBuilder =
					new StrictMode.ThreadPolicy.Builder()
							.detectAll()
							.penaltyLog();
			StrictMode.VmPolicy.Builder vmPolicyBuilder =
					new StrictMode.VmPolicy.Builder()
							.detectAll()
							.penaltyLog();

			if (Utils.hasHoneycomb()) {
				threadPolicyBuilder.penaltyFlashScreen();
				vmPolicyBuilder
						.setClassInstanceLimit(ImageGridActivity.class, 1);
			}
			StrictMode.setThreadPolicy(threadPolicyBuilder.build());
			StrictMode.setVmPolicy(vmPolicyBuilder.build());
		}





	}

	public static boolean hasFroyo() {
		return Build.VERSION.SDK_INT >= VERSION_CODES.FROYO;

	}

	public static boolean hasGingerbread() {
		return Build.VERSION.SDK_INT >= VERSION_CODES.GINGERBREAD;
	}

	public static boolean hasHoneycomb() {
		return Build.VERSION.SDK_INT >= VERSION_CODES.HONEYCOMB;
	}

	public static boolean hasHoneycombMR1() {
		return Build.VERSION.SDK_INT >= VERSION_CODES.HONEYCOMB_MR1;
	}

	public static boolean hasJellyBean() {
		return Build.VERSION.SDK_INT >= VERSION_CODES.JELLY_BEAN;
	}

	public static boolean hasKitKat() {
		return Build.VERSION.SDK_INT >= 19;
	}

	public static List<Camera.Size> getResolutionList(Camera camera)
	{
		Parameters parameters = camera.getParameters();
		return parameters.getSupportedPreviewSizes();
	}

	public static class ResolutionComparator implements Comparator<Camera.Size>{

		@Override
		public int compare(Size lhs, Size rhs) {
			if(lhs.height!=rhs.height)
				return lhs.height-rhs.height;
			else
				return lhs.width-rhs.width;
		}

	}

	public static int getStateHeight(Context context) {
		int stateHeight = 0;
		Resources resources = context.getApplicationContext().getResources();
		int identifierState = resources.getIdentifier("status_bar_height", "dimen", "android");
		if (identifierState > 0) {
			stateHeight = resources.getDimensionPixelSize(identifierState);
		}
		if (stateHeight == 0){
			return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 25, resources.getDisplayMetrics());
		}

		return stateHeight;
	}


	public static Intent getIntent(Message message){
		try {
			JSONObject msgType = message.getJSONObjectAttribute(Message.KEY_MSGTYPE);
			if (!msgType.has("sendVisitorTicket")){
				return null;
			}

			JSONObject sendVisitorTicket = msgType.getJSONObject("sendVisitorTicket");
			String ticket = sendVisitorTicket.optString("ticket");
			String callNickName = sendVisitorTicket.optString("nickname");
			String to = message.to();
			String from = message.from();

			ZuoXiSendRequestObj obj = get(message, ticket, callNickName);
			obj.setTo(to);
			obj.setFrom(from);

			Intent intent = new Intent();
			intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
			intent.putExtra("type", "video");
			intent.putExtra("appid", obj.getAppId());
			intent.putExtra("zuoXiSendRequestObj", obj);
			intent.putExtra("to", obj.getTo());
			intent.putExtra("from", obj.getFrom());
			intent.putExtra("message", message);
			return intent;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}


	private static ZuoXiSendRequestObj get(Message message, String ticket, String nickName) throws JSONException, HyphenateException {

		ZuoXiSendRequestObj obj = new ZuoXiSendRequestObj();
		JSONObject ticketObj = new JSONObject(ticket);

		if (ticketObj.has("isThirdAgent")){
			// 老板本没有isThirdAgent字段
			boolean isThirdAgent = ticketObj.getBoolean("isThirdAgent");
			obj.setIsAddThreeUser(isThirdAgent);

			/*if (ticketObj.has("agentTicket")){
				JSONObject agentTicket = ticketObj.getJSONObject("agentTicket");
				if (agentTicket.has("trueName")){
					obj.setThreeTrueName(agentTicket.getString("trueName"));
					obj.setThreeNiceName(agentTicket.getString("niceName"));
					obj.setThreeUid(agentTicket.getInt("uid"));
					obj.setThreeCallId(agentTicket.getInt("callId"));
				}
			}*/
		}

		if (ticketObj.has("agentTicket")){
			JSONObject agentTicket = ticketObj.getJSONObject("agentTicket");
			if (agentTicket.has("trueName")){
				obj.setThreeTrueName(agentTicket.getString("trueName"));
				obj.setThreeNiceName(agentTicket.getString("niceName"));
				obj.setThreeUid(agentTicket.getInt("uid"));
				obj.setThreeCallId(agentTicket.getInt("callId"));
			}
		}

		// nickname
		obj.setNiceName(ticketObj.getString("niceName"));
		// trueName
		obj.setTrueName(ticketObj.getString("trueName"));
		// callId
		obj.setCallId(ticketObj.getInt("callId"));
		// uid
		obj.setUid(ticketObj.getInt("uid"));
		// token
		obj.setToken(ticketObj.getString("token"));
		// appId
		obj.setAppId(ticketObj.getString("appId"));
		// channel
		obj.setChannel(ticketObj.getString("channel"));

		// 座席端名
		if(TextUtils.isEmpty(nickName) || "null".equalsIgnoreCase(nickName)){
			obj.setNickName(TextUtils.isEmpty(obj.getThreeTrueName()) ? obj.getThreeNiceName() : obj.getThreeTrueName());
		}else {
			obj.setNickName(nickName);
		}

		return obj;
	}

}
