package com.hyphenate.helpdesk.easeui.widget.chatrow;


import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.Browser;
import android.text.Html;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.util.Base64;
import android.view.View;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.Message;
import com.hyphenate.helpdesk.R;
import com.hyphenate.helpdesk.easeui.UIProvider;
import com.hyphenate.helpdesk.easeui.adapter.MessageAdapter;
import com.hyphenate.helpdesk.easeui.ui.VecWebView;
import com.hyphenate.helpdesk.util.Log;

import org.json.JSONArray;
import org.json.JSONObject;


public class ChatRowRootRichText extends ChatRow{

    private VecWebView mVecVebView;

    public ChatRowRootRichText(Context context, Message message, int position, BaseAdapter adapter) {
        super(context, message, position, adapter);
    }

    @Override
    protected void onInflatView() {
        inflater.inflate(message.direct() == Message.Direct.RECEIVE ?
                R.layout.hd_row_received_rich_text : R.layout.hd_row_sent_rich_text, this);
    }

    @Override
    protected void onFindViewById() {
        mVecVebView = findViewById(R.id.vecVebView);
    }

    @Override
    public void onSetUpView() {
        try {
            EMTextMessageBody body = (EMTextMessageBody) message.body();
            String s = body.getMessage();
            JSONArray jsonArray = new JSONArray(s);
            JSONObject jsonObject = (JSONObject) jsonArray.get(0);
            String content = jsonObject.getString("content");
            // content = "<p><em>测试富文本</em></p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><ol><li>富文本返回结果</li><li><strong>加黑显示</strong></li></ol><p><img src='https://seopic.699pic.com/photo/50042/4589.jpg_wh1200.jpg' alt='' /></p>";
            // mVecVebView.loadDataWithBaseURL(null, content, "text/html" , "utf-8", null);//加载html数据
            if (!content.contains("html")){
                content = "<html><head><meta charset='utf-8' content='width=device-width,initial-scale=1.0,maximum-scale=1.0,user-scalable=no,minimum-scale=1.0'name='viewport'><style>img{width: 100%;height: auto;}</style></head><body>"+content+"</body></html>";
            }
            String encodedHtml = Base64.encodeToString(content.getBytes(), Base64.NO_PADDING);
            mVecVebView.loadData(encodedHtml, "text/html" , "base64");//加载html数据
        }catch (Exception e2){
            e2.printStackTrace();
        }
        handleTextMessage();
    }

    protected void handleTextMessage() {
        boolean isShowProgress = UIProvider.getInstance().isShowProgress();
        if (message.direct() == Message.Direct.SEND) {
            setMessageSendCallback();
            switch (message.status()) {
                case CREATE:
                    progressBar.setVisibility(View.GONE);
                    statusView.setVisibility(View.VISIBLE);
                    // 发送消息
                    break;
                case SUCCESS: // 发送成功
                    progressBar.setVisibility(View.GONE);
                    statusView.setVisibility(View.GONE);
                    break;
                case FAIL: // 发送失败
                    progressBar.setVisibility(View.GONE);
                    statusView.setVisibility(View.VISIBLE);
                    break;
                case INPROGRESS: // 发送中
                    if (isShowProgress)
                        progressBar.setVisibility(View.VISIBLE);
                    statusView.setVisibility(View.GONE);
                    break;
                default:
                    break;
            }
        }
    }

    @Override
    protected void onUpdateView() {
        if (adapter instanceof MessageAdapter) {
            ((MessageAdapter) adapter).refresh();
        } else {
            adapter.notifyDataSetChanged();
        }

    }

    @Override
    protected void onBubbleClick() {
        // TODO Auto-generated method stub
    }


    /*private TextView contentView;

    public ChatRowRootRichText(Context context, Message message, int position, BaseAdapter adapter) {
        super(context, message, position, adapter);
    }

    @Override
    protected void onInflatView() {
        inflater.inflate(message.direct() == Message.Direct.RECEIVE ?
                R.layout.hd_row_received_message : R.layout.hd_row_sent_message, this);
    }

    @Override
    protected void onFindViewById() {
        contentView = (TextView) findViewById(R.id.tv_chatcontent);
    }

    @Override
    public void onSetUpView() {
        EMTextMessageBody txtBody = (EMTextMessageBody) message.body();

        String content = "";
        try {
            String s = txtBody.getMessage();
            JSONArray jsonArray = new JSONArray(s);
            JSONObject jsonObject = (JSONObject) jsonArray.get(0);
            //content = jsonObject.getString("content");
            content = "<a href=’http://www.baidu.com’>点击跳转百度</a><p><em>测试富文本</em></p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><ol><li>富文本返回结果</li><li><strong>加黑显示</strong></li></ol><p><img src='https://seopic.699pic.com/photo/50042/4589.jpg_wh1200.jpg' alt='' /></p>";
        }catch (Exception e2){
            e2.printStackTrace();
        }

        //解析html超链接
        //fromHtml method will ignore \n in string
        CharSequence htmlTxt;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
            htmlTxt = Html.fromHtml(content, Html.FROM_HTML_MODE_COMPACT);
        } else {
            htmlTxt = Html.fromHtml(content);
        }

        contentView.setLinksClickable(true);
        contentView.setMovementMethod(LinkMovementMethod.getInstance());

        // 设置内容
        contentView.setText(getClickableHtml(htmlTxt), TextView.BufferType.SPANNABLE);

        handleTextMessage();
    }

    *//**

     * 格式化超链接文本内容并设置点击处理

     * *//*

    private CharSequence getClickableHtml(CharSequence html) {
        SpannableStringBuilder clickableHtmlBuilder = new SpannableStringBuilder(html);
        URLSpan[] urls = clickableHtmlBuilder.getSpans(0, html.length(), URLSpan.class);
        for(final URLSpan span : urls) {
            setLinkClickable(clickableHtmlBuilder, span);
        }

        return clickableHtmlBuilder;

    }

    *//**

     * 设置点击超链接对应的处理内容

     * *//*

    private void setLinkClickable(final SpannableStringBuilder clickableHtmlBuilder,final URLSpan urlSpan) {
        String url = urlSpan.getURL();
        int start = clickableHtmlBuilder.getSpanStart(urlSpan);
        int end = clickableHtmlBuilder.getSpanEnd(urlSpan);
        int flags = clickableHtmlBuilder.getSpanFlags(urlSpan);
        ClickableSpan clickableSpan = new ClickableSpan() {

            public void onClick(View view) {
                Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                context.startActivity(intent);
            }

        };

        clickableHtmlBuilder.setSpan(clickableSpan, start, end, flags);

    }

    @Override
    public void initListener() {
        bubbleLayout.setOnClickListener(null);
        contentView.setOnClickListener(null);
    }

    protected void handleTextMessage() {
        boolean isShowProgress = UIProvider.getInstance().isShowProgress();
        if (message.direct() == Message.Direct.SEND) {
            setMessageSendCallback();
            switch (message.status()) {
                case CREATE:
                    progressBar.setVisibility(View.GONE);
                    statusView.setVisibility(View.VISIBLE);
                    // 发送消息
                    break;
                case SUCCESS: // 发送成功
                    progressBar.setVisibility(View.GONE);
                    statusView.setVisibility(View.GONE);
                    break;
                case FAIL: // 发送失败
                    progressBar.setVisibility(View.GONE);
                    statusView.setVisibility(View.VISIBLE);
                    break;
                case INPROGRESS: // 发送中
                    if (isShowProgress)
                        progressBar.setVisibility(View.VISIBLE);
                    statusView.setVisibility(View.GONE);
                    break;
                default:
                    break;
            }
        }
    }

    @Override
    protected void onUpdateView() {
        if (adapter instanceof MessageAdapter) {
            ((MessageAdapter) adapter).refresh();
        } else {
            adapter.notifyDataSetChanged();
        }

    }

    @Override
    protected void onBubbleClick() {
        // TODO Auto-generated method stub

    }*/



}