/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.CountDownBroadCastManager;
import com.hyphenate.chat.PreferenceUtil;

class CountDownUtils {
    private static final String TAG = "CountDownUtils";
    private static CountDownUtils instance = new CountDownUtils();
    private static int REQUEST_CODE = 0;
    private static int KEY_HANDLE_WHAT = 1;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            try {
                if (msg.what == KEY_HANDLE_WHAT) {
                    long triggerAtTime = (Long)msg.obj;
                    PreferenceUtil.getInstance().setTriggerEventTime(triggerAtTime);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private DownTimeRunnable mDownTimeRunnable;
    private Context mContext;

    CountDownUtils() {
    }

    public static CountDownUtils getInstance() {
        return instance;
    }

    public void init(Context context) {
        this.mContext = context;
        this.mDownTimeRunnable = new DownTimeRunnable(context);
    }

    public void sendBroadcast() {
        this.sendBroadcast(0L);
    }

    public void sendBroadcast(long willTriggerTime) {
        long keepAliveTime;
        this.cancel();
        if (!ChatClient.getInstance().isCountDownDisconnect()) {
            return;
        }
        if (this.mHandler.hasMessages(KEY_HANDLE_WHAT)) {
            this.mHandler.removeMessages(KEY_HANDLE_WHAT);
        }
        if ((keepAliveTime = ChatClient.getInstance().getKeepAliveTime()) <= 0L) {
            return;
        }
        long triggerAtTime = SystemClock.elapsedRealtime() + 60000L * keepAliveTime;
        if (willTriggerTime > 0L) {
            if (willTriggerTime < SystemClock.elapsedRealtime()) {
                try {
                    CountDownBroadCastManager.getCountDownBroadCastManager().sendBroadcast();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            if (willTriggerTime < triggerAtTime) {
                triggerAtTime = willTriggerTime;
            }
        }
        Message message = this.mHandler.obtainMessage();
        message.what = KEY_HANDLE_WHAT;
        message.obj = triggerAtTime;
        this.mHandler.sendMessageDelayed(message, 30000L);
        try {
            this.mHandler.postDelayed((Runnable)this.mDownTimeRunnable, keepAliveTime * 60L * 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancel() {
        try {
            if (this.mDownTimeRunnable != null && this.mHandler != null) {
                this.mHandler.removeCallbacks((Runnable)this.mDownTimeRunnable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class DownTimeRunnable
    implements Runnable {
        DownTimeRunnable(Context context) {
        }

        @Override
        public void run() {
            try {
                CountDownBroadCastManager.getCountDownBroadCastManager().sendBroadcast();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

