/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.support.annotation.NonNull;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMContactListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMContact;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.adapter.EMAContact;
import com.hyphenate.chat.adapter.EMAContactListener;
import com.hyphenate.chat.adapter.EMAContactManager;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.exceptions.HyphenateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EMContactManager {
    EMAContactManager emaObject;
    EMClient mClient;
    private List<EMContactListener> contactListeners = Collections.synchronizedList(new ArrayList());
    private EMAContactListenerImpl contactImpl = new EMAContactListenerImpl();

    EMContactManager(EMClient client, EMAContactManager contactManager) {
        this.mClient = client;
        this.emaObject = new EMAContactManager(contactManager);
        this.emaObject.registerContactListener(this.contactImpl);
    }

    private void handleError(EMAError error) throws HyphenateException {
        if (error.errCode() != 0) {
            throw new HyphenateException(error);
        }
    }

    public void addContact(String username, String reason) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.inviteContact(username, reason, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAddContact(final String username, final String reason, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.addContact(username, reason);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void deleteContact(String username) throws HyphenateException {
        this.deleteContact(username, false);
    }

    public void deleteContact(String username, boolean keepConversation) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.deleteContact(username, eMAError, keepConversation);
        EMClient.getInstance().chatManager().caches.remove(username);
        this.handleError(eMAError);
    }

    public void asyncDeleteContact(final String username, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.deleteContact(username);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public List<String> getAllContactsFromServer() throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.getContactsFromServer(eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncGetAllContactsFromServer(final EMValueCallBack<List<String>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> list = EMContactManager.this.getAllContactsFromServer();
                    callback.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void setContactListener(EMContactListener contactListener) {
        if (!this.contactListeners.contains(contactListener)) {
            this.contactListeners.add(contactListener);
        }
    }

    public void removeContactListener(EMContactListener contactListener) {
        this.contactListeners.remove(contactListener);
    }

    public void addUserToBlackList(String username, boolean both) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.addToBlackList(username, both, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAddUserToBlackList(final String username, final boolean both, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.addUserToBlackList(username, both);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void saveBlackList(List<String> blackList) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.saveBlackList(blackList, eMAError);
        this.handleError(eMAError);
    }

    public void asyncSaveBlackList(final List<String> blackList, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.saveBlackList(blackList);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void removeUserFromBlackList(String username) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.removeFromBlackList(username, eMAError);
        this.handleError(eMAError);
    }

    public void asyncRemoveUserFromBlackList(final String username, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.removeUserFromBlackList(username);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public List<String> getBlackListUsernames() {
        EMAError eMAError = new EMAError();
        return this.emaObject.getBlackListFromDB(eMAError);
    }

    public List<String> getBlackListFromServer() throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.getBlackListFromServer(eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncGetBlackListFromServer(final EMValueCallBack<List<String>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> list = EMContactManager.this.getBlackListFromServer();
                    callback.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void acceptInvitation(String username) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.acceptInvitation(username, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAcceptInvitation(final String username, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.acceptInvitation(username);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void declineInvitation(String username) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.declineInvitation(username, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDeclineInvitation(final String username, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.declineInvitation(username);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public List<String> getContactsFromLocal() throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<String> list = this.getContactsFromDB(eMAError);
        this.handleError(eMAError);
        return list;
    }

    List<String> getContactsFromDB(EMAError error) {
        return this.emaObject.getContactsFromDB(error);
    }

    void onLogout() {
    }

    public List<String> getSelfIdsOnOtherPlatform() throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.getSelfIdsOnOtherPlatform(eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncGetSelfIdsOnOtherPlatform(final EMValueCallBack<List<String>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> list = EMContactManager.this.getSelfIdsOnOtherPlatform();
                    callback.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void asyncSetContactRemark(final @NonNull String username, final @NonNull String remark, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        EMAError eMAError = new EMAError();
                        EMContactManager.this.emaObject.setContactRemark(username, remark, eMAError);
                        EMContactManager.this.handleError(eMAError);
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                    catch (HyphenateException hyphenateException) {
                        if (callback == null) break block3;
                        callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                }
            }
        });
    }

    public EMContact fetchContactFromLocal(String username) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAContact eMAContact = this.emaObject.fetchContactFromLocal(username, eMAError);
        this.handleError(eMAError);
        if (eMAContact == null) {
            return null;
        }
        return new EMContact(eMAContact);
    }

    public void asyncFetchAllContactsFromLocal(final EMValueCallBack<List<EMContact>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        EMAError eMAError = new EMAError();
                        List<EMAContact> list = EMContactManager.this.emaObject.fetchAllContactsFromLocal(eMAError);
                        EMContactManager.this.handleError(eMAError);
                        if (callback != null) {
                            ArrayList<EMContact> arrayList = new ArrayList<EMContact>();
                            for (int i = 0; i < list.size(); ++i) {
                                if (list.get(i) == null) continue;
                                arrayList.add(new EMContact(list.get(i)));
                            }
                            callback.onSuccess(arrayList);
                        }
                    }
                    catch (HyphenateException hyphenateException) {
                        if (callback == null) break block4;
                        callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                }
            }
        });
    }

    public void asyncFetchAllContactsFromServer(final EMValueCallBack<List<EMContact>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        EMAError eMAError = new EMAError();
                        List<EMAContact> list = EMContactManager.this.emaObject.fetchAllContactsFromServer(eMAError);
                        EMContactManager.this.handleError(eMAError);
                        if (callback != null) {
                            ArrayList<EMContact> arrayList = new ArrayList<EMContact>();
                            for (int i = 0; i < list.size(); ++i) {
                                if (list.get(i) == null) continue;
                                arrayList.add(new EMContact(list.get(i)));
                            }
                            callback.onSuccess(arrayList);
                        }
                    }
                    catch (HyphenateException hyphenateException) {
                        if (callback == null) break block4;
                        callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                }
            }
        });
    }

    public void asyncFetchAllContactsFromServer(int limit, String cursor, EMValueCallBack<EMCursorResult<EMContact>> callback) {
        this.mClient.execute(() -> {
            block4: {
                try {
                    EMAError eMAError = new EMAError();
                    EMCursorResult<EMAContact> eMCursorResult = this.emaObject.fetchAllContactsFromServer(limit, cursor, eMAError);
                    this.handleError(eMAError);
                    List list = (List)eMCursorResult.getData();
                    ArrayList<EMContact> arrayList = new ArrayList<EMContact>();
                    for (int i = 0; i < list.size(); ++i) {
                        if (list.get(i) == null) continue;
                        EMContact eMContact = new EMContact((EMAContact)list.get(i));
                        arrayList.add(eMContact);
                    }
                    EMCursorResult eMCursorResult2 = new EMCursorResult();
                    eMCursorResult2.setCursor(eMCursorResult.getCursor());
                    eMCursorResult2.setData(arrayList);
                    if (callback != null) {
                        callback.onSuccess(eMCursorResult2);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callback == null) break block4;
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    class EMAContactListenerImpl
    extends EMAContactListener {
        EMAContactListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactAdded(String username) {
            List list = EMContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (EMContactListener eMContactListener : EMContactManager.this.contactListeners) {
                        eMContactListener.onContactAdded(username);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactDeleted(String username) {
            EMClient.getInstance().chatManager().caches.remove(username);
            List list = EMContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (EMContactListener eMContactListener : EMContactManager.this.contactListeners) {
                        eMContactListener.onContactDeleted(username);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactInvited(String username, String reason) {
            List list = EMContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (EMContactListener eMContactListener : EMContactManager.this.contactListeners) {
                        eMContactListener.onContactInvited(username, reason);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactAgreed(String username) {
            List list = EMContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (EMContactListener eMContactListener : EMContactManager.this.contactListeners) {
                        eMContactListener.onFriendRequestAccepted(username);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactRefused(String username) {
            List list = EMContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (EMContactListener eMContactListener : EMContactManager.this.contactListeners) {
                        eMContactListener.onFriendRequestDeclined(username);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

