/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMBase;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMPushManager;
import com.hyphenate.chat.adapter.EMAConversation;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.util.EMLog;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class EMConversation
extends EMBase<EMAConversation> {
    private static final String TAG = "conversation";
    private static final int LIST_SIZE = 512;

    public EMConversation(EMAConversation conversation) {
        this.emaObject = conversation;
    }

    public Set<EMMarkType> marks() {
        long l = ((EMAConversation)this.emaObject).marks();
        int n = 0;
        HashSet<EMMarkType> hashSet = new HashSet<EMMarkType>();
        do {
            if ((l & 1L) > 0L) {
                hashSet.add(EMMarkType.values()[n]);
            }
            ++n;
        } while ((l >>= 1) > 0L);
        return hashSet;
    }

    public String conversationId() {
        return ((EMAConversation)this.emaObject).conversationId();
    }

    public EMConversationType getType() {
        EMAConversation.EMAConversationType eMAConversationType = ((EMAConversation)this.emaObject)._getType();
        if (eMAConversationType == EMAConversation.EMAConversationType.CHAT) {
            return EMConversationType.Chat;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.GROUPCHAT) {
            return EMConversationType.GroupChat;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.CHATROOM) {
            return EMConversationType.ChatRoom;
        }
        return EMConversationType.Chat;
    }

    public int getUnreadMsgCount() {
        return ((EMAConversation)this.emaObject).unreadMessagesCount();
    }

    public void markAllMessagesAsRead() {
        ((EMAConversation)this.emaObject).markAllMessagesAsRead(true);
    }

    public int getAllMsgCount() {
        return ((EMAConversation)this.emaObject).messagesCount();
    }

    public int getAllMsgCount(long startTimestamp, long endTimestamp) {
        return ((EMAConversation)this.emaObject).messagesCount(startTimestamp, endTimestamp);
    }

    public boolean isChatThread() {
        return ((EMAConversation)this.emaObject).isChatThread();
    }

    public List<EMMessage> loadMoreMsgFromDB(String startMsgId, int pageSize) {
        return this.loadMoreMsgFromDB(startMsgId, pageSize, EMSearchDirection.UP);
    }

    public List<EMMessage> loadMoreMsgFromDB(String startMsgId, int pageSize, EMSearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).loadMoreMessages(startMsgId, pageSize, eMASearchDirection);
        ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            arrayList.add(new EMMessage(eMAMessage));
        }
        this.getCache().addMessages(arrayList);
        return arrayList;
    }

    public List<EMMessage> searchMsgFromDB(long timeStamp, int maxCount, EMSearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(timeStamp, maxCount, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchMsgFromDB(EMMessage.Type type, long timeStamp, int maxCount, String from, EMSearchDirection direction) {
        return this.searchMsgFromDB(EnumSet.of(type), timeStamp, maxCount, from, direction);
    }

    public List<EMMessage> searchMsgFromDB(Set<EMMessage.Type> types, long timeStamp, int maxCount, String from, EMSearchDirection direction) {
        int n = 0;
        if (types != null && types.size() > 0) {
            for (EMMessage.Type object2 : types) {
                n |= 1 << object2.ordinal();
            }
        }
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(n, timeStamp, maxCount, from, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchMsgFromDB(String keywords, long timeStamp, int maxCount, String from, EMSearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(keywords, timeStamp, maxCount, from, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchMsgFromDB(String keywords, long timeStamp, int maxCount, String from, EMSearchDirection direction, EMMessageSearchScope searchScope) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(keywords, timeStamp, maxCount, from, eMASearchDirection.ordinal(), searchScope.ordinal());
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchMsgFromDB(long startTimeStamp, long endTimeStamp, int maxCount) {
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(startTimeStamp, endTimeStamp, maxCount);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchCustomMsgFromDB(String keywords, long timeStamp, int maxCount, String from, EMSearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchCustomMessages(keywords, timeStamp, maxCount, from, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public EMMessage getMessage(String messageId, boolean markAsRead) {
        EMLog.d(TAG, "getMessage messageId: " + messageId + " markAsRead: " + markAsRead);
        EMMessage eMMessage = this.getCache().getMessage(messageId);
        if (eMMessage == null) {
            EMAMessage eMAMessage = ((EMAConversation)this.emaObject).loadMessage(messageId);
            if (eMAMessage == null) {
                return null;
            }
            eMMessage = new EMMessage(eMAMessage);
        }
        ((EMAConversation)this.emaObject).markMessageAsRead(messageId, markAsRead);
        return eMMessage;
    }

    public void markMessageAsRead(String messageId) {
        ((EMAConversation)this.emaObject).markMessageAsRead(messageId, true);
    }

    public List<EMMessage> getAllMessages() {
        if (this.getCache().isEmpty()) {
            EMAMessage eMAMessage = ((EMAConversation)this.emaObject).latestMessage();
            ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
            if (eMAMessage != null) {
                arrayList.add(new EMMessage(eMAMessage));
            }
            this.getCache().addMessages(arrayList);
        }
        return this.getCache().getAllMessages();
    }

    public void removeMessage(String messageId) {
        EMLog.d(TAG, "remove msg from conversation: " + messageId);
        ((EMAConversation)this.emaObject)._removeMessage(messageId);
        this.getCache().removeMessage(messageId);
    }

    public EMMessage getLastMessage() {
        if (this.getCache().isEmpty()) {
            EMAMessage eMAMessage = ((EMAConversation)this.emaObject).latestMessage();
            EMMessage eMMessage = eMAMessage == null ? null : new EMMessage(eMAMessage);
            this.getCache().addMessage(eMMessage);
            return eMMessage;
        }
        return this.getCache().getLastMessage();
    }

    public EMMessage getLatestMessageFromOthers() {
        EMAMessage eMAMessage = ((EMAConversation)this.emaObject).latestMessageFromOthers();
        EMMessage eMMessage = eMAMessage == null ? null : new EMMessage(eMAMessage);
        this.getCache().addMessage(eMMessage);
        return eMMessage;
    }

    public void clear() {
        this.getCache().clear();
    }

    public void clearAllMessages() {
        ((EMAConversation)this.emaObject).clearAllMessages();
        this.getCache().clear();
    }

    public void setExtField(String ext) {
        if (!this.isChatThread()) {
            ((EMAConversation)this.emaObject)._setExtField(ext);
        }
    }

    public String getExtField() {
        return ((EMAConversation)this.emaObject).extField();
    }

    public boolean isPinned() {
        return ((EMAConversation)this.emaObject).isPinned();
    }

    public long getPinnedTime() {
        return ((EMAConversation)this.emaObject).getPinnedTime();
    }

    public static EMConversationType msgType2ConversationType(String id, EMMessage.ChatType type) {
        switch (type) {
            case GroupChat: {
                return EMConversationType.GroupChat;
            }
            case ChatRoom: {
                return EMConversationType.ChatRoom;
            }
        }
        return EMConversationType.Chat;
    }

    public boolean isGroup() {
        EMConversationType eMConversationType = this.getType();
        return !this.isChatThread() && (eMConversationType == EMConversationType.GroupChat || eMConversationType == EMConversationType.ChatRoom);
    }

    public boolean insertMessage(EMMessage msg) {
        EMLog.d(TAG, "insertMessage msg: {msgId:" + msg.getMsgId() + " conversation:" + msg.conversationId() + " unread:" + msg.isUnread() + "}");
        boolean bl = ((EMAConversation)this.emaObject).insertMessage((EMAMessage)msg.emaObject);
        if (bl) {
            this.getCache().addMessage(msg);
        }
        return bl;
    }

    public boolean appendMessage(EMMessage msg) {
        EMLog.d(TAG, "appendMessage msg: {msgId:" + msg.getMsgId() + " conversation:" + msg.conversationId() + " unread:" + msg.isUnread() + "}");
        boolean bl = ((EMAConversation)this.emaObject).appendMessage((EMAMessage)msg.emaObject);
        if (bl) {
            this.getCache().addMessage(msg);
        }
        return bl;
    }

    public boolean updateMessage(EMMessage msg) {
        EMLog.d(TAG, "updateMessage msg{ msgId:" + msg.getMsgId() + " conversation:" + msg.conversationId() + " unread:" + msg.isUnread() + "}");
        boolean bl = ((EMAConversation)this.emaObject).updateMessage((EMAMessage)msg.emaObject);
        if (bl) {
            this.getCache().addMessage(msg);
        }
        return bl;
    }

    public String getMessageAttachmentPath() {
        String string = EMClient.getInstance().getChatConfigPrivate().E();
        return string + "/" + EMClient.getInstance().getCurrentUser() + "/" + this.conversationId();
    }

    public void removeMessagesFromServer(List<String> msgIdList, EMCallBack callBack) {
        EMClient.getInstance().chatManager().removeMessagesFromServer(this.conversationId(), this.getType(), msgIdList, callBack);
    }

    public void removeMessagesFromServer(long beforeTimeStamp, EMCallBack callBack) {
        EMClient.getInstance().chatManager().removeMessagesFromServer(this.conversationId(), this.getType(), beforeTimeStamp, callBack);
    }

    public boolean removeMessages(long startTime, long endTime) {
        EMLog.d(TAG, "remove msgs from conversation by startTime: " + startTime + " ,endTime: " + endTime);
        boolean bl = ((EMAConversation)this.emaObject)._removeMessage(startTime, endTime);
        if (bl) {
            this.getCache().removeMessages(startTime, endTime);
        }
        return bl;
    }

    public List<EMMessage> pinnedMessages() {
        List<EMAMessage> list = ((EMAConversation)this.emaObject).pinnedMessages();
        ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
        for (int i = 0; i < list.size(); ++i) {
            EMAMessage eMAMessage = list.get(i);
            arrayList.add(new EMMessage(eMAMessage));
        }
        return arrayList;
    }

    public EMPushManager.EMPushRemindType pushRemindType() {
        return EMPushManager.EMPushRemindType.values()[((EMAConversation)this.emaObject).remindType()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageCache getCache() {
        MessageCache messageCache;
        Map<String, MessageCache> map = EMClient.getInstance().chatManager().caches;
        synchronized (map) {
            messageCache = EMClient.getInstance().chatManager().caches.get(((EMAConversation)this.emaObject).conversationId());
            if (messageCache == null) {
                messageCache = new MessageCache();
            }
            EMClient.getInstance().chatManager().caches.put(((EMAConversation)this.emaObject).conversationId(), messageCache);
        }
        return messageCache;
    }

    public static enum EMMarkType {
        MARK_0,
        MARK_1,
        MARK_2,
        MARK_3,
        MARK_4,
        MARK_5,
        MARK_6,
        MARK_7,
        MARK_8,
        MARK_9,
        MARK_10,
        MARK_11,
        MARK_12,
        MARK_13,
        MARK_14,
        MARK_15,
        MARK_16,
        MARK_17,
        MARK_18,
        MARK_19;

    }

    public static enum EMConversationType {
        Chat,
        GroupChat,
        ChatRoom;

    }

    public static enum EMSearchDirection {
        UP,
        DOWN;

    }

    static class MessageCache {
        TreeMap<Long, Object> sortedMessages = new TreeMap(new MessageComparator());
        Map<String, EMMessage> messages = new HashMap<String, EMMessage>();
        Map<String, Long> idTimeMap = new HashMap<String, Long>();
        boolean hasDuplicateTime = false;
        final boolean sortByServerTime = EMClient.getInstance().getChatConfigPrivate().b().isSortMessageByServerTime();

        MessageCache() {
        }

        public synchronized EMMessage getMessage(String msgId) {
            if (msgId == null || msgId.isEmpty()) {
                return null;
            }
            return this.messages.get(msgId);
        }

        public synchronized void addMessages(List<EMMessage> msgs) {
            for (EMMessage eMMessage : msgs) {
                this.addMessage(eMMessage);
            }
        }

        public synchronized void addMessage(EMMessage msg) {
            long l;
            if (msg == null || msg.emaObject == null || msg.getMsgTime() == 0L || msg.getMsgTime() == -1L || msg.getMsgId() == null || msg.getMsgId().isEmpty() || msg.getType() == EMMessage.Type.CMD) {
                return;
            }
            String string = msg.getMsgId();
            if (this.messages.containsKey(string)) {
                Long l2 = this.idTimeMap.get(string);
                if (l2 != null) {
                    this.removeMessageByTime(string, l2);
                }
                this.messages.remove(string);
                this.idTimeMap.remove(string);
            }
            long l3 = l = this.sortByServerTime ? msg.getMsgTime() : msg.localTime();
            if (this.sortedMessages.containsKey(l)) {
                this.hasDuplicateTime = true;
                Object object = this.sortedMessages.get(l);
                if (object != null) {
                    if (object instanceof EMMessage) {
                        if (TextUtils.equals((CharSequence)((EMMessage)object).getMsgId(), (CharSequence)msg.getMsgId())) {
                            return;
                        }
                        LinkedList<EMMessage> linkedList = new LinkedList<EMMessage>();
                        linkedList.add((EMMessage)object);
                        linkedList.add(msg);
                        this.sortedMessages.put(l, linkedList);
                    } else if (object instanceof List) {
                        List list = (List)object;
                        list.add(msg);
                    }
                }
            } else {
                this.sortedMessages.put(l, msg);
            }
            this.messages.put(string, msg);
            this.idTimeMap.put(string, l);
        }

        public synchronized void removeMessage(String msgId) {
            if (msgId == null || msgId.isEmpty()) {
                return;
            }
            EMMessage eMMessage = this.messages.get(msgId);
            if (eMMessage != null) {
                Long l = this.idTimeMap.get(msgId);
                if (l != null) {
                    this.removeMessageByTime(msgId, l);
                    this.idTimeMap.remove(msgId);
                }
                this.messages.remove(msgId);
            }
        }

        public synchronized void removeMessages(long startTime, long endTime) {
            if (startTime > endTime) {
                EMLog.e(EMConversation.TAG, " removeMessages error: startTime > endTime");
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Long l : this.sortedMessages.keySet()) {
                if (l < startTime || l > endTime) continue;
                Object object = this.sortedMessages.get(l);
                if (object != null && object instanceof List) {
                    List list = (List)object;
                    for (EMMessage eMMessage : list) {
                        if (eMMessage == null || eMMessage.getMsgId() == null) continue;
                        arrayList.add(eMMessage.getMsgId());
                    }
                    continue;
                }
                if (object == null || !(object instanceof EMMessage)) continue;
                arrayList.add(((EMMessage)object).getMsgId());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                this.removeMessage((String)arrayList.get(i));
            }
        }

        synchronized void replaceMsgId(String oldMsgId, String newMsgId) {
            if (TextUtils.isEmpty((CharSequence)oldMsgId) || TextUtils.isEmpty((CharSequence)newMsgId)) {
                return;
            }
            EMMessage eMMessage = this.messages.get(oldMsgId);
            if (eMMessage != null) {
                Long l = this.idTimeMap.get(oldMsgId);
                if (l != null) {
                    Object object = this.sortedMessages.get(l);
                    this.sortedMessages.remove(l);
                    this.idTimeMap.remove(oldMsgId);
                    long l2 = this.sortByServerTime ? eMMessage.getMsgTime() : eMMessage.localTime();
                    this.sortedMessages.put(l2, object);
                    this.idTimeMap.put(newMsgId, l2);
                }
                this.messages.remove(oldMsgId);
                this.messages.put(newMsgId, eMMessage);
            }
        }

        private synchronized void removeMessageByTime(String msgId, long time) {
            if (msgId == null || msgId.isEmpty()) {
                return;
            }
            if (this.hasDuplicateTime && this.sortedMessages.containsKey(time)) {
                Object object = this.sortedMessages.get(time);
                if (object != null && object instanceof List) {
                    List list = (List)object;
                    for (EMMessage eMMessage : list) {
                        if (eMMessage == null || eMMessage.getMsgId() == null || !eMMessage.getMsgId().equals(msgId)) continue;
                        list.remove(eMMessage);
                        break;
                    }
                } else {
                    this.sortedMessages.remove(time);
                }
            } else {
                this.sortedMessages.remove(time);
            }
        }

        public synchronized List<EMMessage> getAllMessages() {
            ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
            if (!this.hasDuplicateTime) {
                for (Object object : this.sortedMessages.values()) {
                    arrayList.add((EMMessage)object);
                }
            } else {
                for (Object object : this.sortedMessages.values()) {
                    if (object == null) continue;
                    if (object instanceof List) {
                        arrayList.addAll((List)object);
                        continue;
                    }
                    arrayList.add((EMMessage)object);
                }
            }
            return arrayList;
        }

        public synchronized EMMessage getLastMessage() {
            if (this.sortedMessages.isEmpty()) {
                return null;
            }
            Object object = this.sortedMessages.lastEntry().getValue();
            if (object == null) {
                return null;
            }
            if (object instanceof EMMessage) {
                return (EMMessage)object;
            }
            if (object instanceof List) {
                List list = (List)object;
                if (list.size() > 0) {
                    return (EMMessage)list.get(list.size() - 1);
                }
                return null;
            }
            return null;
        }

        public synchronized void clear() {
            this.sortedMessages.clear();
            this.messages.clear();
            this.idTimeMap.clear();
        }

        public synchronized boolean isEmpty() {
            return this.sortedMessages.isEmpty();
        }

        class MessageComparator
        implements Comparator<Long> {
            MessageComparator() {
            }

            @Override
            public int compare(Long time0, Long time1) {
                long l = time0 - time1;
                if (l > 0L) {
                    return 1;
                }
                if (l == 0L) {
                    return 0;
                }
                return -1;
            }
        }
    }

    public static enum EMMessageSearchScope {
        CONTENT,
        EXT,
        ALL;

    }
}

