/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.EMBase;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessageStatistics;
import com.hyphenate.chat.adapter.EMAMessageStatistics;
import com.hyphenate.chat.adapter.EMAStatisticsManager;

public class EMStatisticsManager
extends EMBase<EMAStatisticsManager> {
    EMClient mClient;

    EMStatisticsManager(EMClient client, EMAStatisticsManager manager) {
        this.emaObject = manager;
        this.mClient = client;
    }

    public EMMessageStatistics getMessageStatistics(String messageId) {
        EMAMessageStatistics eMAMessageStatistics = ((EMAStatisticsManager)this.emaObject).getMsgStatistics(messageId);
        if (eMAMessageStatistics != null) {
            return new EMMessageStatistics(eMAMessageStatistics);
        }
        return null;
    }

    public int getMessageCount(long startTimestamp, long endTimestamp, EMSearchMessageDirect direct, EMSearchMessageType type) {
        return ((EMAStatisticsManager)this.emaObject).searchMsgStatisticsNumber(startTimestamp, endTimestamp, direct.getIndex(), type.getIndex());
    }

    public long getMessageSize(long startTimestamp, long endTimestamp, EMSearchMessageDirect direct, EMSearchMessageType type) {
        return ((EMAStatisticsManager)this.emaObject).searchMsgStatisticsSize(startTimestamp, endTimestamp, direct.getIndex(), type.getIndex());
    }

    boolean removeMessagesBeforeTime(long timestamp) {
        return ((EMAStatisticsManager)this.emaObject).removeMsgStatisticsBeforeTime(timestamp);
    }

    public static enum EMSearchMessageDirect {
        SEND(0),
        RECEIVE(1),
        ALL(100);

        private final int index;

        private EMSearchMessageDirect(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum EMSearchMessageType {
        TXT(0),
        IMAGE(1),
        VIDEO(2),
        LOCATION(3),
        VOICE(4),
        FILE(5),
        CMD(6),
        CUSTOM(7),
        ALL(100);

        private final int index;

        private EMSearchMessageType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

