/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.Conversation;
import com.hyphenate.chat.KefuDBManager;
import com.hyphenate.chat.Message;
import com.hyphenate.chat.OfficialAccount;
import com.hyphenate.helpdesk.util.Log;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class KefuConversationManager {
    private static final String TAG = "kefu conversation";
    private static final int DEFAULT_LOAD_MESSAGE_COUNT = 20;
    List<String> recallMessageIds = Collections.synchronizedList(new ArrayList());
    private static KefuConversationManager instance = new KefuConversationManager();
    private Hashtable<String, Message> allMessages = new Hashtable();
    private Hashtable<String, Conversation> conversations = new Hashtable();
    private Hashtable<String, Conversation> tempConversations = new Hashtable();
    private boolean allConversationsLoaded = false;

    public static KefuConversationManager getInstance() {
        return instance;
    }

    void loadAllConversations() {
        this.loadAllConversations(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void loadAllConversations(int messagesNum) {
        if (this.allConversationsLoaded) {
            return;
        }
        this.conversations.clear();
        this.tempConversations.clear();
        this.conversations = KefuDBManager.getInstance().loadAllParticipantsWithMsgs(messagesNum);
        EMLog.d(TAG, "load converstations size:" + this.conversations.size());
        Hashtable<String, Conversation> hashtable = this.conversations;
        synchronized (hashtable) {
            for (Conversation conversation : this.conversations.values()) {
                for (Message msg : conversation.messages) {
                    this.allMessages.put(msg.messageId(), msg);
                }
            }
        }
        this.loadAllRecallMessageIds(20);
        this.allConversationsLoaded = true;
    }

    void loadAllRecallMessageIds(int limit) {
        this.recallMessageIds.clear();
        List<String> msgIds = KefuDBManager.getInstance().loadAllRecalledMessageIds(limit);
        this.recallMessageIds.addAll(msgIds);
    }

    Conversation getConversation(String conversationId) {
        if (conversationId == null) {
            EMLog.e(TAG, "conversationId is null");
            return null;
        }
        Conversation chat = null;
        if (this.conversations != null && this.conversations.containsKey(conversationId)) {
            chat = this.conversations.get(conversationId);
        }
        if (chat == null && this.tempConversations.containsKey(conversationId)) {
            chat = this.tempConversations.get(conversationId);
        }
        if (chat == null) {
            ArrayList<Message> chatHistory = new ArrayList<Message>();
            long msgCount = KefuDBManager.getInstance().getConversationMessageCount(conversationId, true);
            chat = new Conversation(conversationId, chatHistory, msgCount);
            this.tempConversations.put(conversationId, chat);
        }
        return chat;
    }

    public String getMessageByExtMsgId(String extMsgId) {
        return KefuDBManager.getInstance().getMessageIdByExtMsgId(extMsgId);
    }

    public boolean removeConversation(String username) {
        return this.removeConversation(username, true);
    }

    public boolean isRecalledMessage(String msgId) {
        for (String recallMessageId : this.recallMessageIds) {
            if (!recallMessageId.equals(msgId)) continue;
            return true;
        }
        return false;
    }

    public void addRecalledMessage(String msgId) {
        if (!this.recallMessageIds.contains(msgId)) {
            this.recallMessageIds.add(msgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConversation(String conversationId, boolean isRemoveMessages) {
        EMLog.d(TAG, "remove conversation for user:" + conversationId);
        Conversation chat = this.conversations.get(conversationId);
        if (chat == null) {
            chat = this.getConversation(conversationId);
        }
        if (chat == null) {
            return false;
        }
        if (isRemoveMessages) {
            KefuDBManager.getInstance().deleteChatMsgs(conversationId);
        }
        KefuDBManager.getInstance().deleteConversation(conversationId);
        try {
            List<Message> convMessages;
            List<Message> list = convMessages = chat.getAllMessages();
            synchronized (list) {
                for (Message msg : convMessages) {
                    if (!this.allMessages.containsKey(msg.messageId())) continue;
                    this.allMessages.remove(msg.messageId());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        chat.clear();
        this.conversations.remove(conversationId);
        if (this.tempConversations.containsKey(conversationId)) {
            this.tempConversations.remove(conversationId);
        }
        KefuDBManager.getInstance().deleteMarketingInfoByConversationId(conversationId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAllUnreadMsgCount() {
        Hashtable<String, Conversation> hashtable = this.conversations;
        synchronized (hashtable) {
            Enumeration<String> enumeration = this.conversations.keys();
            while (enumeration.hasMoreElements()) {
                String username = enumeration.nextElement();
                this.conversations.get(username).markAllMessagesAsRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearConversation(String username) {
        EMLog.d(TAG, "clear conversation for user:" + username);
        Conversation chat = this.conversations.get(username);
        if (chat == null) {
            return false;
        }
        KefuDBManager.getInstance().deleteChatMsgs(username);
        try {
            List<Message> convMessages;
            List<Message> list = convMessages = chat.getAllMessages();
            synchronized (list) {
                for (Message msg : convMessages) {
                    if (!this.allMessages.containsKey(msg.messageId())) continue;
                    this.allMessages.remove(msg.messageId());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        chat.clear();
        return true;
    }

    public Hashtable<String, Conversation> getAllConversations() {
        return this.conversations;
    }

    void removeMessage(String msg_id) {
        this.allMessages.remove(msg_id);
    }

    public Message getMessage(String messageId) {
        return this.allMessages.get(messageId);
    }

    void addMessage(Message msg) {
        this.addMessage(msg, true);
    }

    void addMessage(Message msg, boolean unreadcountIncrease) {
        String msgId = msg.messageId();
        if (msgId == null) {
            Log.d("chat", "messageId is null");
            return;
        }
        if (this.isRecalledMessage(msgId)) {
            return;
        }
        if (!this.allMessages.containsKey(msgId)) {
            this.allMessages.put(msgId, msg);
            String conversationId = msg.direct() == Message.Direct.RECEIVE ? msg.from() : msg.to();
            OfficialAccount officialAccount = msg.getOfficialAccount();
            String marketings = msg.getMarketings();
            Conversation conversation = this.getConversation(conversationId);
            conversation.addMessage(msg, unreadcountIncrease);
            if (msg.direct() == Message.Direct.RECEIVE) {
                conversation.setOfficialAccount(officialAccount);
                conversation.setMarketings(marketings);
            }
            if (!this.conversations.containsKey(conversationId)) {
                this.conversations.put(conversationId, conversation);
            }
        }
    }

    private void addConversationToDB(Message message) {
        String username = "";
        username = message.from().equals(ChatClient.getInstance().currentUserName()) ? message.to() : message.from();
        OfficialAccount officialAccount = message.getOfficialAccount();
        String marketings = message.getMarketings();
        KefuDBManager.getInstance().addConversation(username, officialAccount, marketings, message.direct() == Message.Direct.SEND);
    }

    public void saveMessage(Message message) {
        EMLog.d(TAG, "save message:" + message.messageId());
        try {
            if (!this.allMessages.containsKey(message.messageId())) {
                this.addMessage(message);
                KefuDBManager.getInstance().saveMessage(message);
            }
            this.addConversationToDB(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveMessage(Message message, boolean unreadcountIncrease) {
        EMLog.d(TAG, "save message:" + message.messageId());
        try {
            this.addMessage(message, unreadcountIncrease);
            KefuDBManager.getInstance().saveMessage(message);
            this.addConversationToDB(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnreadMsgsCount() {
        int count = 0;
        Hashtable<String, Conversation> hashtable = this.conversations;
        synchronized (hashtable) {
            Collection<Conversation> c = this.conversations.values();
            Iterator<Conversation> iter = c.iterator();
            while (iter.hasNext()) {
                count += iter.next().unreadMessagesCount();
            }
        }
        EMLog.d(TAG, "getUnreadMsgsCount:" + count);
        return count;
    }

    public synchronized void clear() {
        if (this.conversations != null) {
            this.conversations.clear();
        }
        if (this.tempConversations != null) {
            this.tempConversations.clear();
        }
        if (this.allMessages != null) {
            this.allMessages.clear();
        }
        this.allConversationsLoaded = false;
    }
}

