/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.graphics.BitmapFactory;
import android.os.Build;
import android.text.TextUtils;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMNormalFileMessageBody;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.chat.EMVoiceMessageBody;
import com.hyphenate.chat.MarketingHttpClient;
import com.hyphenate.chat.Message;
import com.hyphenate.chat.PreferenceUtil;
import com.hyphenate.chat.VecDatabaseManager;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.httpclient.HttpClient;
import com.hyphenate.helpdesk.httpclient.HttpClientException;
import com.hyphenate.helpdesk.httpclient.HttpRequestBuilder;
import com.hyphenate.helpdesk.httpclient.HttpResponse;
import com.hyphenate.helpdesk.httpclient.HttpResponseHandler;
import com.hyphenate.helpdesk.util.Log;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.ImageUtils;
import com.hyphenate.util.UriUtils;
import java.io.File;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONObject;

class KefuHttpClient {
    private static final String TAG = "httpclient";
    public static int DEFAULT_CONNECTION_TIMEOUT = 20000;
    public static int DEFAULT_READ_TIMEOUT = 20000;
    private static ExecutorService sendThreadPool = Executors.newFixedThreadPool(10);
    private static ExecutorService receiveThreadPool = Executors.newCachedThreadPool();
    private static String uniqueId;

    KefuHttpClient() {
    }

    public static void sendMessageByKefuRest(Message message, EMCallBack callBack) {
        if (!ChatClient.getInstance().isLoggedInBefore()) {
            if (callBack != null) {
                callBack.onError(201, "user no login");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)ChatClient.getInstance().tenantId())) {
            if (callBack != null) {
                callBack.onError(500, "tenantId is not set");
            }
            return;
        }
        if (message.getType() == Message.Type.TXT) {
            KefuHttpClient.sendTxtMessageByKefuRest(message, callBack);
        } else if (message.getType() == Message.Type.IMAGE) {
            KefuHttpClient.sendImageMessageByKefuRest(message, callBack);
        } else if (message.getType() == Message.Type.VOICE) {
            KefuHttpClient.sendVoiceMessageByKefuRest(message, callBack);
        } else if (message.getType() == Message.Type.FILE) {
            KefuHttpClient.sendFileMessageByKefuRest(message, callBack);
        } else if (message.getType() == Message.Type.VIDEO) {
            KefuHttpClient.sendVideoMessageByKefuRest(message, callBack);
        } else if (message.getType() == Message.Type.CMD) {
            KefuHttpClient.sendCmdMessageByKefuRest(message, callBack);
        } else if (callBack != null) {
            callBack.onError(1, "no support message type");
        }
    }

    public static void receiveMessages(final String toUserName, final EMValueCallBack<String> callback) {
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        String remoteUrl = KefuHttpClient.getReceiveMessageUrl(toUserName);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder httpRequestBuilder = httpClient.get(remoteUrl);
                        HttpResponse httpResponse = httpRequestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        if (status_code / 100 == 2) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            if (callback != null) {
                                callback.onSuccess(buffer.toString());
                            }
                        } else if (callback != null) {
                            callback.onError(status_code, "statusCode is :" + status_code);
                        }
                    }
                    catch (Exception e) {
                        EMLog.d(KefuHttpClient.TAG, "e: " + e.getMessage());
                        if (callback == null) break block7;
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    private static void sendVideoMessageByKefuRest(final Message message, final EMCallBack callback) {
        final EMVideoMessageBody videoMessageBody = (EMVideoMessageBody)message.body();
        EMLog.d(TAG, "sendVideoMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block11: {
                    String thumbnailUrl = videoMessageBody.getLocalThumb();
                    File thumbnail = new File(thumbnailUrl);
                    if (!thumbnail.exists()) {
                        if (callback != null) {
                            callback.onError(400, "thumbnail file not found");
                        }
                        return;
                    }
                    String localPath = videoMessageBody.getLocalUrl();
                    final File file = new File(localPath);
                    if (!file.exists()) {
                        if (callback != null) {
                            callback.onError(400, "file not found");
                        }
                        return;
                    }
                    String appKey = ChatClient.getInstance().appKey();
                    if (appKey == null) {
                        EMLog.e(KefuHttpClient.TAG, "appkey is not set");
                        if (callback != null) {
                            callback.onError(100, "appkey is not set");
                        }
                        return;
                    }
                    final String orgName = appKey.split("#")[0];
                    final String appName = appKey.split("#")[1];
                    final String currentUserName = ChatClient.getInstance().currentUserName();
                    String uploadUrl = KefuHttpClient.getUploadMediaFileUrl(orgName, appName, currentUserName);
                    final String[] thumb = new String[1];
                    try {
                        KefuHttpClient.uploadAttachment(uploadUrl, thumbnailUrl, new HttpResponseHandler(){

                            @Override
                            public void onTimeout() throws Exception {
                                if (callback != null) {
                                    callback.onError(301, "server timeout.");
                                }
                            }

                            @Override
                            public void onResponse(HttpResponse response, long contentLength) throws Exception {
                                String result = response.getResponseBody();
                                JSONObject jsonObject = new JSONObject(result);
                                thumb[0] = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback != null) {
                            callback.onError(1, "result :" + e.getMessage());
                        }
                        return;
                    }
                    try {
                        KefuHttpClient.uploadAttachment(uploadUrl, localPath, new HttpResponseHandler(){

                            @Override
                            public void onTimeout() throws Exception {
                                if (callback != null) {
                                    callback.onError(301, "server timeout.");
                                }
                            }

                            @Override
                            public void onResponse(HttpResponse response, long contentLength) throws Exception {
                                if (thumb[0] == null) {
                                    if (callback != null) {
                                        callback.onError(402, "thumb upload failed.");
                                    }
                                    return;
                                }
                                String result = response.getResponseBody();
                                JSONObject jsonObject = new JSONObject(result);
                                String fileName = jsonObject.getString("fileName");
                                String remoteUrl = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                                String messageUrl = KefuHttpClient.getSendMessageUrl();
                                JSONObject bodyJson = new JSONObject();
                                JSONObject extJson = new JSONObject(message.attributes);
                                bodyJson.put("from", (Object)currentUserName);
                                bodyJson.put("to", (Object)message.to());
                                JSONArray jsonMsgBodyArr = new JSONArray();
                                JSONObject jsonMsgBody = new JSONObject();
                                jsonMsgBody.put("type", (Object)"video");
                                jsonMsgBody.put("url", (Object)remoteUrl);
                                jsonMsgBody.put("filename", (Object)fileName);
                                jsonMsgBody.put("file_length", file.length());
                                jsonMsgBody.put("thumb", (Object)thumb[0]);
                                jsonMsgBodyArr.put((Object)jsonMsgBody);
                                bodyJson.put("bodies", (Object)jsonMsgBodyArr);
                                bodyJson.put("originType", (Object)"app");
                                bodyJson.put("orgName", (Object)orgName);
                                bodyJson.put("appName", (Object)appName);
                                bodyJson.put("ext", (Object)extJson);
                                HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
                                httpClient1.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                                httpClient1.setReadTimeout(DEFAULT_READ_TIMEOUT);
                                HttpRequestBuilder requestBuilder1 = httpClient1.post(messageUrl);
                                requestBuilder1.content(bodyJson.toString().getBytes(), "application/json");
                                HttpResponse msgHttpResponse = requestBuilder1.execute();
                                assert (msgHttpResponse != null);
                                String msgResult = msgHttpResponse.getResponseBody();
                                EMLog.d(KefuHttpClient.TAG, "msg result:" + msgResult);
                                JSONObject jsonResult = new JSONObject(msgResult);
                                String statusParam = jsonResult.getString("status");
                                if (statusParam.equalsIgnoreCase("Ok")) {
                                    if (callback != null) {
                                        videoMessageBody.setRemoteUrl(remoteUrl);
                                        callback.onSuccess();
                                        return;
                                    }
                                } else if (statusParam.equalsIgnoreCase("FAIL")) {
                                    if (msgResult.contains("duplicated message") || msgResult.contains("im_routeway_partner_002")) {
                                        EMLog.d(KefuHttpClient.TAG, "rest status_code: duplicated message");
                                        if (callback != null) {
                                            videoMessageBody.setRemoteUrl(remoteUrl);
                                            callback.onSuccess();
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_001")) {
                                        if (callback != null) {
                                            callback.onError(1, "Can not find channel, please check appkey & im service num.");
                                        }
                                        return;
                                    }
                                    if (msgResult.contains("im_routeway_partner_003")) {
                                        if (callback != null) {
                                            callback.onError(1, "Server Got an exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_004")) {
                                        if (callback != null) {
                                            callback.onError(1, "Got bodies exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_005")) {
                                        if (callback != null) {
                                            callback.onError(1, "msg_id_for_ack is blank.");
                                        }
                                        return;
                                    }
                                    if (callback != null) {
                                        callback.onError(1, "result:" + msgResult);
                                    }
                                    return;
                                }
                                if (callback != null) {
                                    callback.onError(1, "result :" + msgResult);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block11;
                        callback.onError(1, "result :" + e.getMessage());
                    }
                }
            }
        });
    }

    private static void sendFileMessageByKefuRest(final Message message, final EMCallBack callback) {
        final EMFileMessageBody fileMessageBody = (EMFileMessageBody)message.body();
        EMLog.d(TAG, "sendFileMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    String localPath = fileMessageBody.getLocalUrl();
                    final File file = new File(localPath);
                    if (!file.exists()) {
                        if (callback != null) {
                            callback.onError(400, "file not found");
                        }
                        return;
                    }
                    String appKey = ChatClient.getInstance().appKey();
                    if (appKey == null) {
                        EMLog.e(KefuHttpClient.TAG, "appkey is not set");
                        if (callback != null) {
                            callback.onError(100, "appkey is not set");
                        }
                        return;
                    }
                    try {
                        final String orgName = appKey.split("#")[0];
                        final String appName = appKey.split("#")[1];
                        final String currentUserName = ChatClient.getInstance().currentUserName();
                        String uploadUrl = KefuHttpClient.getUploadMediaFileUrl(orgName, appName, currentUserName);
                        KefuHttpClient.uploadAttachment(uploadUrl, localPath, new HttpResponseHandler(){

                            @Override
                            public void onTimeout() throws Exception {
                                if (callback != null) {
                                    callback.onError(301, "server timeout.");
                                }
                            }

                            @Override
                            public void onResponse(HttpResponse response, long contentLength) throws Exception {
                                String result = response.getResponseBody();
                                JSONObject jsonObject = new JSONObject(result);
                                String fileName = jsonObject.getString("fileName");
                                String remoteUrl = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                                String messageUrl = KefuHttpClient.getSendMessageUrl();
                                JSONObject bodyJson = new JSONObject();
                                JSONObject extJson = new JSONObject(message.attributes);
                                bodyJson.put("from", (Object)currentUserName);
                                bodyJson.put("to", (Object)message.to());
                                JSONArray jsonMsgBodyArr = new JSONArray();
                                JSONObject jsonMsgBody = new JSONObject();
                                jsonMsgBody.put("type", (Object)"file");
                                jsonMsgBody.put("url", (Object)remoteUrl);
                                jsonMsgBody.put("filename", (Object)fileName);
                                jsonMsgBody.put("file_length", file.length());
                                jsonMsgBodyArr.put((Object)jsonMsgBody);
                                bodyJson.put("bodies", (Object)jsonMsgBodyArr);
                                bodyJson.put("originType", (Object)"app");
                                bodyJson.put("orgName", (Object)orgName);
                                bodyJson.put("appName", (Object)appName);
                                bodyJson.put("ext", (Object)extJson);
                                HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
                                httpClient1.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                                httpClient1.setReadTimeout(DEFAULT_READ_TIMEOUT);
                                HttpRequestBuilder requestBuilder1 = httpClient1.post(messageUrl);
                                requestBuilder1.content(bodyJson.toString().getBytes(), "application/json");
                                HttpResponse msgHttpResponse = requestBuilder1.execute();
                                assert (msgHttpResponse != null);
                                String msgResult = msgHttpResponse.getResponseBody();
                                EMLog.d(KefuHttpClient.TAG, "msg result:" + msgResult);
                                JSONObject jsonResult = new JSONObject(msgResult);
                                String statusParam = jsonResult.getString("status");
                                if (statusParam.equalsIgnoreCase("Ok")) {
                                    if (callback != null) {
                                        fileMessageBody.setRemoteUrl(remoteUrl);
                                        callback.onSuccess();
                                        return;
                                    }
                                } else if (statusParam.equalsIgnoreCase("FAIL")) {
                                    if (msgResult.contains("duplicated message") || msgResult.contains("im_routeway_partner_002")) {
                                        EMLog.d(KefuHttpClient.TAG, "rest status_code: duplicated message");
                                        if (callback != null) {
                                            fileMessageBody.setRemoteUrl(remoteUrl);
                                            callback.onSuccess();
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_001")) {
                                        if (callback != null) {
                                            callback.onError(1, "Can not find channel, please check appkey & im service num.");
                                        }
                                        return;
                                    }
                                    if (msgResult.contains("im_routeway_partner_003")) {
                                        if (callback != null) {
                                            callback.onError(1, "Server Got an exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_004")) {
                                        if (callback != null) {
                                            callback.onError(1, "Got bodies exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_005")) {
                                        if (callback != null) {
                                            callback.onError(1, "msg_id_for_ack is blank.");
                                        }
                                        return;
                                    }
                                    if (callback != null) {
                                        callback.onError(1, "result:" + msgResult);
                                    }
                                    return;
                                }
                                if (callback != null) {
                                    callback.onError(1, "result :" + msgResult);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block6;
                        callback.onError(1, "result :" + e.getMessage());
                    }
                }
            }
        });
    }

    private static void sendVoiceMessageByKefuRest(final Message message, final EMCallBack callback) {
        final EMVoiceMessageBody voiceMessageBody = (EMVoiceMessageBody)message.body();
        EMLog.d(TAG, "sendVoiceMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    String localPath = voiceMessageBody.getLocalUrl();
                    File file = new File(localPath);
                    if (!file.exists()) {
                        if (callback != null) {
                            callback.onError(400, "file not found");
                        }
                        return;
                    }
                    String appKey = ChatClient.getInstance().appKey();
                    if (appKey == null) {
                        EMLog.e(KefuHttpClient.TAG, "appkey is not set");
                        if (callback != null) {
                            callback.onError(100, "appkey is not set");
                        }
                        return;
                    }
                    try {
                        final String orgName = appKey.split("#")[0];
                        final String appName = appKey.split("#")[1];
                        final String currentUserName = ChatClient.getInstance().currentUserName();
                        String uploadUrl = KefuHttpClient.getUploadMediaFileUrl(orgName, appName, currentUserName);
                        KefuHttpClient.uploadAttachment(uploadUrl, localPath, new HttpResponseHandler(){

                            @Override
                            public void onTimeout() throws Exception {
                                if (callback != null) {
                                    callback.onError(301, "server timeout.");
                                }
                            }

                            @Override
                            public void onResponse(HttpResponse response, long contentLength) throws Exception {
                                String result = response.getResponseBody();
                                JSONObject jsonObject = new JSONObject(result);
                                String fileName = jsonObject.getString("fileName");
                                String remoteUrl = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                                String messageUrl = KefuHttpClient.getSendMessageUrl();
                                JSONObject bodyJson = new JSONObject();
                                JSONObject extJson = new JSONObject(message.attributes);
                                bodyJson.put("from", (Object)currentUserName);
                                bodyJson.put("to", (Object)message.to());
                                JSONArray jsonMsgBodyArr = new JSONArray();
                                JSONObject jsonMsgBody = new JSONObject();
                                jsonMsgBody.put("type", (Object)"audio");
                                jsonMsgBody.put("url", (Object)remoteUrl);
                                jsonMsgBody.put("filename", (Object)fileName);
                                jsonMsgBody.put("length", voiceMessageBody.getLength());
                                jsonMsgBodyArr.put((Object)jsonMsgBody);
                                bodyJson.put("bodies", (Object)jsonMsgBodyArr);
                                bodyJson.put("originType", (Object)"app");
                                bodyJson.put("orgName", (Object)orgName);
                                bodyJson.put("appName", (Object)appName);
                                bodyJson.put("ext", (Object)extJson);
                                HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
                                httpClient1.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                                httpClient1.setReadTimeout(DEFAULT_READ_TIMEOUT);
                                HttpRequestBuilder requestBuilder1 = httpClient1.post(messageUrl);
                                requestBuilder1.content(bodyJson.toString().getBytes(), "application/json");
                                HttpResponse msgHttpResponse = requestBuilder1.execute();
                                assert (msgHttpResponse != null);
                                String msgResult = msgHttpResponse.getResponseBody();
                                EMLog.d(KefuHttpClient.TAG, "msg result:" + msgResult);
                                JSONObject jsonResult = new JSONObject(msgResult);
                                String statusParam = jsonResult.getString("status");
                                if (statusParam.equalsIgnoreCase("Ok")) {
                                    if (callback != null) {
                                        voiceMessageBody.setRemoteUrl(remoteUrl);
                                        callback.onSuccess();
                                        return;
                                    }
                                } else if (statusParam.equalsIgnoreCase("FAIL")) {
                                    if (msgResult.contains("duplicated message") || msgResult.contains("im_routeway_partner_002")) {
                                        EMLog.d(KefuHttpClient.TAG, "rest status_code: duplicated message");
                                        if (callback != null) {
                                            voiceMessageBody.setRemoteUrl(remoteUrl);
                                            callback.onSuccess();
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_001")) {
                                        if (callback != null) {
                                            callback.onError(1, "Can not find channel, please check appkey & im service num.");
                                        }
                                        return;
                                    }
                                    if (msgResult.contains("im_routeway_partner_003")) {
                                        if (callback != null) {
                                            callback.onError(1, "Server Got an exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_004")) {
                                        if (callback != null) {
                                            callback.onError(1, "Got bodies exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_005")) {
                                        if (callback != null) {
                                            callback.onError(1, "msg_id_for_ack is blank.");
                                        }
                                        return;
                                    }
                                    if (callback != null) {
                                        callback.onError(1, "result:" + msgResult);
                                    }
                                    return;
                                }
                                if (callback != null) {
                                    callback.onError(1, "result :" + msgResult);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        EMLog.e(KefuHttpClient.TAG, "e:" + e.getMessage());
                        if (callback == null) break block6;
                        callback.onError(1, "error:" + e.getMessage());
                    }
                }
            }
        });
    }

    private static void uploadAttachment(String remoteUrl, String localPath, HttpResponseHandler handler) throws HttpClientException {
        EMLog.d(TAG, "remoteUrl:" + remoteUrl);
        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
        requestBuilder.header("Authorization", "Bearer " + ChatClient.getInstance().accessToken());
        requestBuilder.cookie("tenantId", ChatClient.getInstance().tenantId());
        requestBuilder.contentFromFile(localPath);
        requestBuilder.to(handler);
        requestBuilder.execute();
    }

    private static void uploadVecAttachment(String remoteUrl, String localPath, HttpResponseHandler handler) throws HttpClientException {
        EMLog.d(TAG, "remoteUrl:" + remoteUrl);
        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
        requestBuilder.header("Authorization", "Bearer " + ChatClient.getInstance().accessToken());
        requestBuilder.cookie("tenantId", ChatClient.getInstance().tenantId());
        requestBuilder.contentFromFile(localPath);
        requestBuilder.to(handler);
        requestBuilder.execute();
    }

    private static void sendImageMessageByKefuRest(final Message message, final EMCallBack callback) {
        final EMImageMessageBody imageMessageBody = (EMImageMessageBody)message.body();
        EMLog.d(TAG, "sendImageMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    String localPath = imageMessageBody.getLocalUrl();
                    File file = new File(localPath);
                    if (!file.exists()) {
                        if (callback != null) {
                            callback.onError(400, "file not found");
                        }
                        return;
                    }
                    String appKey = ChatClient.getInstance().appKey();
                    if (appKey == null) {
                        EMLog.e(KefuHttpClient.TAG, "appkey is not set");
                        if (callback != null) {
                            callback.onError(100, "appkey is not set");
                        }
                        return;
                    }
                    try {
                        final String orgName = appKey.split("#")[0];
                        final String appName = appKey.split("#")[1];
                        final String currentUserName = ChatClient.getInstance().currentUserName();
                        String uploadUrl = KefuHttpClient.getUploadMediaFileUrl(orgName, appName, currentUserName);
                        KefuHttpClient.uploadAttachment(uploadUrl, localPath, new HttpResponseHandler(){

                            @Override
                            public void onTimeout() throws Exception {
                                if (callback != null) {
                                    callback.onError(301, "server timeout.");
                                }
                            }

                            @Override
                            public void onResponse(HttpResponse response, long contentLength) throws Exception {
                                String result = response.getResponseBody();
                                JSONObject jsonObject = new JSONObject(result);
                                String fileName = jsonObject.getString("fileName");
                                String remoteUrl = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                                String messageUrl = KefuHttpClient.getSendMessageUrl();
                                JSONObject bodyJson = new JSONObject();
                                JSONObject extJson = new JSONObject(message.attributes);
                                bodyJson.put("from", (Object)currentUserName);
                                bodyJson.put("to", (Object)message.to());
                                JSONArray jsonMsgBodyArr = new JSONArray();
                                JSONObject jsonMsgBody = new JSONObject();
                                jsonMsgBody.put("type", (Object)"img");
                                jsonMsgBody.put("url", (Object)remoteUrl);
                                jsonMsgBody.put("filename", (Object)fileName);
                                jsonMsgBody.put("thumb", (Object)remoteUrl);
                                jsonMsgBodyArr.put((Object)jsonMsgBody);
                                bodyJson.put("bodies", (Object)jsonMsgBodyArr);
                                bodyJson.put("originType", (Object)"app");
                                bodyJson.put("orgName", (Object)orgName);
                                bodyJson.put("appName", (Object)appName);
                                bodyJson.put("ext", (Object)extJson);
                                HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
                                httpClient1.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                                httpClient1.setReadTimeout(DEFAULT_READ_TIMEOUT);
                                HttpRequestBuilder requestBuilder1 = httpClient1.post(messageUrl);
                                requestBuilder1.content(bodyJson.toString().getBytes(), "application/json");
                                HttpResponse msgHttpResponse = requestBuilder1.execute();
                                assert (msgHttpResponse != null);
                                String msgResult = msgHttpResponse.getResponseBody();
                                EMLog.d(KefuHttpClient.TAG, "msg result:" + msgResult);
                                JSONObject jsonResult = new JSONObject(msgResult);
                                String statusParam = jsonResult.getString("status");
                                if (statusParam.equalsIgnoreCase("Ok")) {
                                    if (callback != null) {
                                        imageMessageBody.setRemoteUrl(remoteUrl);
                                        imageMessageBody.setThumbnailUrl(remoteUrl);
                                        callback.onSuccess();
                                        return;
                                    }
                                } else if (statusParam.equalsIgnoreCase("FAIL")) {
                                    if (msgResult.contains("duplicated message") || msgResult.contains("im_routeway_partner_002")) {
                                        EMLog.d(KefuHttpClient.TAG, "rest status_code: duplicated message");
                                        if (callback != null) {
                                            imageMessageBody.setThumbnailUrl(remoteUrl);
                                            imageMessageBody.setRemoteUrl(remoteUrl);
                                            callback.onSuccess();
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_001")) {
                                        if (callback != null) {
                                            callback.onError(1, "Can not find channel, please check appkey & im service num.");
                                        }
                                        return;
                                    }
                                    if (msgResult.contains("im_routeway_partner_003")) {
                                        if (callback != null) {
                                            callback.onError(1, "Server Got an exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_004")) {
                                        if (callback != null) {
                                            callback.onError(1, "Got bodies exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_005")) {
                                        if (callback != null) {
                                            callback.onError(1, "msg_id_for_ack is blank.");
                                        }
                                        return;
                                    }
                                    if (callback != null) {
                                        callback.onError(1, "result:" + msgResult);
                                    }
                                    return;
                                }
                                if (callback != null) {
                                    callback.onError(1, "result :" + msgResult);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        EMLog.e(KefuHttpClient.TAG, "e:" + e.getMessage());
                        if (callback == null) break block6;
                        callback.onError(1, "error:" + e.getMessage());
                    }
                }
            }
        });
    }

    private static void sendCmdMessageByKefuRest(final Message message, final EMCallBack callBack) {
        final EMCmdMessageBody messageBody = (EMCmdMessageBody)message.body();
        EMLog.d(TAG, "sendCmdMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block21: {
                    String remoteUrl = KefuHttpClient.getSendMessageUrl();
                    try {
                        String appKey = ChatClient.getInstance().appKey();
                        if (appKey == null) {
                            EMLog.e(KefuHttpClient.TAG, "send message appkey is null");
                            return;
                        }
                        String orgName = appKey.split("#")[0];
                        String appName = appKey.split("#")[1];
                        JSONObject bodyJson = new JSONObject();
                        JSONObject extJson = new JSONObject(message.attributes);
                        bodyJson.put("from", (Object)ChatClient.getInstance().currentUserName());
                        bodyJson.put("to", (Object)message.to());
                        JSONArray jsonMsgBodyArr = new JSONArray();
                        JSONObject jsonMsgBody = new JSONObject();
                        jsonMsgBody.put("type", (Object)"cmd");
                        jsonMsgBody.put("action", (Object)messageBody.action());
                        jsonMsgBodyArr.put((Object)jsonMsgBody);
                        bodyJson.put("bodies", (Object)jsonMsgBodyArr);
                        bodyJson.put("originType", (Object)"app");
                        bodyJson.put("orgName", (Object)orgName);
                        bodyJson.put("appName", (Object)appName);
                        bodyJson.put("ext", (Object)extJson);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        requestBuilder.header("Content-Type", "application/json");
                        requestBuilder.content(bodyJson.toString().getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "cmd rest status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            JSONObject jsonResult = new JSONObject(result);
                            String statusParam = jsonResult.getString("status");
                            if (statusParam.equalsIgnoreCase("OK")) {
                                EMLog.d(KefuHttpClient.TAG, "rest status_code :ok");
                                if (callBack != null) {
                                    callBack.onSuccess();
                                    return;
                                }
                            } else if (statusParam.equalsIgnoreCase("FAIL")) {
                                if (result.contains("duplicated message") || result.contains("im_routeway_partner_002")) {
                                    EMLog.d(KefuHttpClient.TAG, "rest status_code: duplicated message");
                                    if (callBack != null) {
                                        callBack.onSuccess();
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_001")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "Can not find channel, please check appkey & im service num.");
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_003")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "Server Got an exception");
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_004")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "Got bodies exception");
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_005")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "msg_id_for_ack is blank.");
                                    }
                                    return;
                                }
                                if (callBack != null) {
                                    callBack.onError(1, "result:" + result);
                                }
                                return;
                            }
                            EMLog.d(KefuHttpClient.TAG, "rest status_code: FAIL :" + status_code);
                            if (callBack != null) {
                                callBack.onError(1, "statusCode:" + status_code);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callBack == null) break block21;
                        callBack.onError(1, "error:" + e.getMessage());
                    }
                }
            }
        });
    }

    private static void sendTxtMessageByKefuRest(final Message message, final EMCallBack callBack) {
        final EMTextMessageBody textMessageBody = (EMTextMessageBody)message.body();
        EMLog.d(TAG, "sendMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block21: {
                    String remoteUrl = KefuHttpClient.getSendMessageUrl();
                    try {
                        String appKey = ChatClient.getInstance().appKey();
                        if (appKey == null) {
                            EMLog.e(KefuHttpClient.TAG, "send message appkey is null");
                            return;
                        }
                        String orgName = appKey.split("#")[0];
                        String appName = appKey.split("#")[1];
                        JSONObject bodyJson = new JSONObject();
                        JSONObject extJson = new JSONObject(message.attributes);
                        bodyJson.put("from", (Object)ChatClient.getInstance().currentUserName());
                        bodyJson.put("to", (Object)message.to());
                        JSONArray jsonMsgBodyArr = new JSONArray();
                        JSONObject jsonMsgBody = new JSONObject();
                        jsonMsgBody.put("type", (Object)"txt");
                        jsonMsgBody.put("msg", (Object)textMessageBody.getMessage());
                        jsonMsgBodyArr.put((Object)jsonMsgBody);
                        bodyJson.put("bodies", (Object)jsonMsgBodyArr);
                        bodyJson.put("originType", (Object)"app");
                        bodyJson.put("orgName", (Object)orgName);
                        bodyJson.put("appName", (Object)appName);
                        bodyJson.put("ext", (Object)extJson);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        requestBuilder.header("Content-Type", "application/json");
                        requestBuilder.content(bodyJson.toString().getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "rest status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            JSONObject jsonResult = new JSONObject(result);
                            String statusParam = jsonResult.getString("status");
                            if (statusParam.equalsIgnoreCase("OK")) {
                                EMLog.d(KefuHttpClient.TAG, "rest status_code :ok");
                                if (callBack != null) {
                                    callBack.onSuccess();
                                    return;
                                }
                            } else if (statusParam.equalsIgnoreCase("FAIL")) {
                                if (result.contains("duplicated message") || result.contains("im_routeway_partner_002")) {
                                    EMLog.d(KefuHttpClient.TAG, "rest status_code: duplicated message");
                                    if (callBack != null) {
                                        callBack.onSuccess();
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_001")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "Can not find channel, please check appkey & im service num.");
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_003")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "Server Got an exception");
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_004")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "Got bodies exception");
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_005")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "msg_id_for_ack is blank.");
                                    }
                                    return;
                                }
                                if (callBack != null) {
                                    callBack.onError(1, "result:" + result);
                                }
                                return;
                            }
                            EMLog.d(KefuHttpClient.TAG, "rest status_code: FAIL :" + status_code);
                            if (callBack != null) {
                                callBack.onError(1, "statusCode:" + status_code);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callBack == null) break block21;
                        callBack.onError(1, "error:" + e.getMessage());
                    }
                }
            }
        });
    }

    private static String getSendMessageUrl() {
        String kefuHost = ChatClient.getInstance().kefuRestServer();
        return String.format("%1$s/v1/imgateway/messages?uniqueId=%2$s", kefuHost, KefuHttpClient.getUniqueId());
    }

    private static String getUploadMediaFileUrl(String orgName, String appName, String currentUser) {
        String kefuHost = ChatClient.getInstance().kefuRestServer();
        String tenantId = ChatClient.getInstance().tenantId();
        return String.format("%1$s/v1/Tenant/%2$s/%3$s/%4$s/%5$s/MediaFiles?uniqueId=%6$s", kefuHost, tenantId, orgName, appName, currentUser, KefuHttpClient.getUniqueId());
    }

    private static String getVecUploadMediaFileUrl() {
        String tenantId = ChatClient.getInstance().tenantId();
        String urlRoot = ChatClient.getInstance().kefuRestServer();
        return String.format("%1$s/v1/Service/vec/visitor/Tenant/%2$s/MediaFiles", urlRoot, tenantId);
    }

    private static String getReceiveMessageUrl(String toUserName) {
        String kefuHost = ChatClient.getInstance().kefuRestServer();
        String appKey = ChatClient.getInstance().appKey();
        if (appKey == null) {
            EMLog.e(TAG, "receive message url appkey is null");
            return null;
        }
        String orgName = appKey.split("#")[0];
        String appName = appKey.split("#")[1];
        String visitorId = ChatClient.getInstance().currentUserName();
        return String.format("%1$s/v1/imgateway/messages?orgName=%2$s&appName=%3$s&easemobId=%4$s&visitorEasemobId=%5$s&uniqueId=%6$s", kefuHost, orgName, appName, toUserName, visitorId, KefuHttpClient.getUniqueId());
    }

    public static void asyncSendDeviceInfo(final String tenantid, final String targetUser, final ValueCallBack<String> callback) {
        if (TextUtils.isEmpty((CharSequence)tenantid)) {
            if (callback != null) {
                callback.onError(-1, "tenantid is empty");
            }
            return;
        }
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block9: {
                    try {
                        String username = ChatClient.getInstance().currentUserName();
                        String appKey = ChatClient.getInstance().appKey();
                        JSONObject jsonBody = new JSONObject();
                        jsonBody.put("equipment", (Object)"android");
                        jsonBody.put("system", (Object)("Android " + Build.VERSION.SDK_INT));
                        String appVersion = ChatClient.getInstance().getOptions().getAppVersion();
                        if (appVersion != null && !TextUtils.isEmpty((CharSequence)appVersion)) {
                            jsonBody.put("version", (Object)appVersion);
                        } else {
                            jsonBody.put("version", (Object)Build.MODEL);
                        }
                        jsonBody.put("carrierOperator", (Object)Build.MANUFACTURER);
                        String url = ChatClient.getInstance().kefuRestServer() + "/v1/tenants/" + tenantid + "/servicesessions/attributes?visitorUserName=" + username + "&appKey=" + URLEncoder.encode(appKey, "utf-8") + "&imServiceNumber=" + targetUser + "&uniqueId=" + KefuHttpClient.getUniqueId();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.post(url);
                        requestBuilder.header("Content-Type", "application/json");
                        requestBuilder.content(jsonBody.toString().getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "asyncSendDeviceInfo status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callback != null) {
                                callback.onSuccess(result);
                            }
                        } else if (callback != null) {
                            callback.onError(-1, "asyncSendDeviceInfo from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block9;
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    public static void asyncGetInviteEvaluation(String toUser, final String serviceSessionId, final ValueCallBack<String> callBack) {
        final String tenantId = ChatClient.getInstance().tenantId();
        if (TextUtils.isEmpty((CharSequence)tenantId)) {
            if (callBack != null) {
                callBack.onError(-1, "tenantid is null");
            }
            return;
        }
        if (!TextUtils.isDigitsOnly((CharSequence)tenantId)) {
            if (callBack != null) {
                callBack.onError(-1, "tenantid isn't digit, IllegalArgumentException");
            }
            return;
        }
        final String currentUser = ChatClient.getInstance().currentUserName();
        if (TextUtils.isEmpty((CharSequence)currentUser)) {
            if (callBack != null) {
                callBack.onError(-1, "please login first");
            }
            return;
        }
        String appkey = ChatClient.getInstance().appKey();
        if (appkey == null || !appkey.contains("#")) {
            if (callBack != null) {
                callBack.onError(-1, "appkey is IllegalArgumentException");
            }
            return;
        }
        final String orgName = appkey.split("#")[0];
        final String appName = appkey.split("#")[1];
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        String url = String.format("%1$s/v1/webimplugin/tenants/%2$s/evaluationdegrees?serviceSessionId=%3$s", ChatClient.getInstance().kefuRestServer(), tenantId, serviceSessionId);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(url);
                        requestBuilder.header("Content-Type", "application/json");
                        requestBuilder.param("orgName", orgName);
                        requestBuilder.param("appName", appName);
                        requestBuilder.param("userName", currentUser);
                        requestBuilder.param("token", ChatClient.getInstance().accessToken());
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "asyncGetInviteEvaluation status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        } else if (callBack != null) {
                            callBack.onError(-1, "asyncGetInviteEvaluation from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callBack == null) break block8;
                        callBack.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    public static void asyncGetCurrentVisitor(String toUser, final ValueCallBack<String> callBack) {
        final String tenantId = ChatClient.getInstance().tenantId();
        if (TextUtils.isEmpty((CharSequence)tenantId)) {
            if (callBack != null) {
                callBack.onError(-1, "tenantid is null");
            }
            return;
        }
        if (!TextUtils.isDigitsOnly((CharSequence)tenantId)) {
            if (callBack != null) {
                callBack.onError(-1, "tenantid isn't digit, IllegalArgumentException");
            }
            return;
        }
        final String currentUser = ChatClient.getInstance().currentUserName();
        if (TextUtils.isEmpty((CharSequence)currentUser)) {
            if (callBack != null) {
                callBack.onError(-1, "please login first");
            }
            return;
        }
        String appkey = ChatClient.getInstance().appKey();
        if (appkey == null || !appkey.contains("#")) {
            if (callBack != null) {
                callBack.onError(-1, "appkey is IllegalArgumentException");
            }
            return;
        }
        final String orgName = appkey.split("#")[0];
        final String appName = appkey.split("#")[1];
        final String techChannelInfo = (appkey + "#" + toUser).replace("#", "%23");
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        String url = String.format("%1$s/v1/webimplugin/tenants/%2$s/visitors?uniqueId=%3$s", ChatClient.getInstance().kefuRestServer(), tenantId, KefuHttpClient.getUniqueId());
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(url);
                        requestBuilder.header("Content-Type", "application/json");
                        requestBuilder.param("orgName", orgName);
                        requestBuilder.param("appName", appName);
                        requestBuilder.param("userName", currentUser);
                        requestBuilder.param("token", ChatClient.getInstance().accessToken());
                        requestBuilder.param("techChannelInfo", techChannelInfo);
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "dns status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        } else if (callBack != null) {
                            callBack.onError(-1, "load dns from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callBack == null) break block8;
                        callBack.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    private static String urlAppendSdkVersion(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        String tempUrl = url;
        tempUrl = !tempUrl.contains("?") ? tempUrl + "?" : tempUrl + "&";
        tempUrl = tempUrl + "sdkVersion=";
        tempUrl = tempUrl + ChatClient.getInstance().sdkVersion();
        tempUrl = tempUrl + "&appKey=";
        if (ChatClient.getInstance().appKey() != null) {
            tempUrl = tempUrl + ChatClient.getInstance().appKey().replace("#", "%23");
        }
        tempUrl = tempUrl + "&uniqueId=";
        tempUrl = tempUrl + KefuHttpClient.getUniqueId();
        return tempUrl;
    }

    private static String getUniqueId() {
        if (!TextUtils.isEmpty((CharSequence)uniqueId)) {
            return uniqueId;
        }
        try {
            String uuid = PreferenceUtil.getInstance().getUniqueId();
            if (TextUtils.isEmpty((CharSequence)uuid)) {
                uuid = UUID.randomUUID().toString();
                PreferenceUtil.getInstance().setUniqueId(uuid);
            }
            uniqueId = uuid;
            return uuid;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void asyncLoadServerDns(final String tenantid, final ValueCallBack<String> callback) {
        if (TextUtils.isEmpty((CharSequence)tenantid)) {
            if (callback != null) {
                callback.onError(-1, "tenantid is empty");
            }
            return;
        }
        if (!TextUtils.isDigitsOnly((CharSequence)tenantid)) {
            if (callback != null) {
                callback.onError(-1, "tenantid must be digits");
            }
            return;
        }
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        String url = ChatClient.getInstance().kefuRestServer() + "/v1/visitors/tenants/" + tenantid;
                        url = KefuHttpClient.urlAppendSdkVersion(url);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(url);
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "dns status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            Log.e("uuuuuuuuu", "result = " + result);
                            if (callback != null) {
                                callback.onSuccess(result);
                            }
                        } else if (callback != null) {
                            callback.onError(-1, "load dns from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block7;
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    public static void getRobotWelcome(final String toChatUsername, final ValueCallBack<JSONObject> callback) {
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block14: {
                    try {
                        String host = ChatClient.getInstance().kefuRestServer();
                        String tenantid = ChatClient.getInstance().tenantId();
                        if (TextUtils.isEmpty((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid cannot empty");
                            }
                            return;
                        }
                        if (!TextUtils.isDigitsOnly((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid must is digits");
                            }
                            return;
                        }
                        int pos = ChatClient.getInstance().appKey().indexOf("#");
                        int len = ChatClient.getInstance().appKey().length();
                        String orgName = ChatClient.getInstance().appKey().substring(0, pos);
                        String appkey = ChatClient.getInstance().appKey().substring(pos + 1, len);
                        String url_welcome = "/v1/webimplugin/tenants/robots/welcome?channelType=easemob&originType=app&orgName=%s&appName=%s&userName=%s&tenantId=%s&agentUsername=&queueName=&keyword=";
                        String url = ChatClient.getInstance().kefuRestServer() + String.format(url_welcome, orgName, appkey, toChatUsername, tenantid);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(url);
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "getRobotWelcome status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callback != null) {
                                if (TextUtils.isEmpty((CharSequence)result)) {
                                    callback.onSuccess(null);
                                } else {
                                    JSONObject greeting;
                                    JSONObject jsonObject = new JSONObject(result);
                                    if (jsonObject.has("entity") && (greeting = jsonObject.getJSONObject("entity")).has("greetingText")) {
                                        String menu = greeting.getString("greetingText").replace("&amp;quot;", "\"");
                                        JSONObject temp = new JSONObject();
                                        temp.put("greetingText", (Object)menu);
                                        jsonObject = temp;
                                    }
                                    callback.onSuccess(jsonObject);
                                }
                            }
                        } else if (callback != null) {
                            callback.onError(-1, "getRobotWelcome from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block14;
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    public static void getRobotWelcomeData(final String toChatUsername, final ValueCallBack<JSONObject> callback) {
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block13: {
                    try {
                        String host = ChatClient.getInstance().kefuRestServer();
                        String tenantid = ChatClient.getInstance().tenantId();
                        if (TextUtils.isEmpty((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid cannot empty");
                            }
                            return;
                        }
                        if (!TextUtils.isDigitsOnly((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid must is digits");
                            }
                            return;
                        }
                        int pos = ChatClient.getInstance().appKey().indexOf("#");
                        int len = ChatClient.getInstance().appKey().length();
                        String orgName = ChatClient.getInstance().appKey().substring(0, pos);
                        String appkey = ChatClient.getInstance().appKey().substring(pos + 1, len);
                        String url_welcome = "/v1/webimplugin/tenants/robots/welcome?channelType=easemob&originType=app&orgName=%s&appName=%s&userName=%s&tenantId=%s&agentUsername=&queueName=&keyword=";
                        String url = ChatClient.getInstance().kefuRestServer() + String.format(url_welcome, orgName, appkey, toChatUsername, tenantid);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(url);
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "getRobotWelcome status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callback != null) {
                                if (TextUtils.isEmpty((CharSequence)result)) {
                                    callback.onSuccess(new JSONObject());
                                } else {
                                    callback.onSuccess(new JSONObject(result));
                                }
                            }
                        } else if (callback != null) {
                            callback.onError(-1, "getRobotWelcome from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block13;
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    public static void getRobotWelcome(final String toChatUsername, final String visitorUserName, final ValueCallBack<JSONObject> callback) {
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block13: {
                    try {
                        String host = ChatClient.getInstance().kefuRestServer();
                        String tenantid = ChatClient.getInstance().tenantId();
                        if (TextUtils.isEmpty((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid cannot empty");
                            }
                            return;
                        }
                        if (!TextUtils.isDigitsOnly((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid must is digits");
                            }
                            return;
                        }
                        int pos = ChatClient.getInstance().appKey().indexOf("#");
                        int len = ChatClient.getInstance().appKey().length();
                        String orgName = ChatClient.getInstance().appKey().substring(0, pos);
                        String appkey = ChatClient.getInstance().appKey().substring(pos + 1, len);
                        String url_welcome = "/v1/webimplugin/tenants/robots/welcome?channelType=easemob&originType=app&orgName=%s&appName=%s&userName=%s&tenantId=%s&visitorUserName=%s&agentUsername=&queueName=&keyword=";
                        String url = ChatClient.getInstance().kefuRestServer() + String.format(url_welcome, orgName, appkey, toChatUsername, tenantid, visitorUserName);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(url);
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "getRobotWelcome status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callback != null) {
                                if (TextUtils.isEmpty((CharSequence)result)) {
                                    callback.onSuccess(new JSONObject());
                                } else {
                                    JSONObject jsonObject = new JSONObject(result);
                                    callback.onSuccess(jsonObject);
                                }
                            }
                        } else if (callback != null) {
                            callback.onError(-1, "getRobotWelcome from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block13;
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    public static void postRobotQuality(Message msg, final boolean isResolved, final List<String> tags, final EMCallBack callBack) {
        final String robotAgentId = msg.robotAgentId();
        final String commentInfo = msg.satisfacionCommentKey();
        if (!msg.isNeedToScore()) {
            callBack.onError(1, "do not need score");
            return;
        }
        if (robotAgentId == null || commentInfo == null) {
            callBack.onError(1, "No robot info");
            return;
        }
        final String host = ChatClient.getInstance().kefuRestServer();
        final String tenantid = ChatClient.getInstance().tenantId();
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block17: {
                    try {
                        String url = host + "/v1/webimplugin/tenants/" + tenantid + "/robot-agents/" + robotAgentId + "/satisfaction-comment";
                        int score = isResolved ? 1 : 2;
                        String reasonTag = "";
                        if (tags != null && tags.size() > 0) {
                            reasonTag = TextUtils.join((CharSequence)",", (Iterable)tags);
                        }
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.post(url);
                        requestBuilder.header("Content-Type", "application/json");
                        JSONObject jsonBody = new JSONObject();
                        if (!reasonTag.isEmpty()) {
                            jsonBody.put("reasonTag", (Object)reasonTag);
                        }
                        jsonBody.put("type", (Object)Integer.toString(score));
                        jsonBody.put("satisfactionCommentKey", (Object)commentInfo);
                        requestBuilder.content(jsonBody.toString().getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "postRobotQuality code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            try {
                                JSONObject jsonObject = new JSONObject(result);
                                if (jsonObject == null || !jsonObject.has("status")) break block17;
                                String status = jsonObject.getString("status");
                                if (status.equals("OK")) {
                                    if (callBack != null) {
                                        callBack.onSuccess();
                                    }
                                } else {
                                    String errCode = jsonObject.getString("errorCode");
                                    if (errCode.equals("KEFU_ROBOT_INTEGRATION_0207")) {
                                        if (callBack != null) {
                                            callBack.onError(1, "satisfaction comment already comment");
                                        }
                                    } else if (callBack != null) {
                                        callBack.onError(1, result);
                                    }
                                }
                                break block17;
                            }
                            catch (Exception e) {
                                EMLog.d(KefuHttpClient.TAG, e.getMessage());
                            }
                            break block17;
                        }
                        StringBuffer buffer = new StringBuffer();
                        httpResponse.read(buffer);
                        String result = buffer.toString();
                        if (callBack != null) {
                            callBack.onError(1, result);
                        }
                    }
                    catch (Exception e) {
                        callBack.onError(1, e.getMessage());
                    }
                }
            }
        });
    }

    public static void getRobotQualityTags(Message msg, final EMValueCallBack<List<String>> callBack) {
        final String robotAgentId = msg.robotAgentId();
        String commentInfo = msg.satisfacionCommentKey();
        if (!msg.isNeedToScore()) {
            callBack.onError(1, "do not need score");
            return;
        }
        if (robotAgentId == null || commentInfo == null) {
            callBack.onError(1, "No robot info");
            return;
        }
        final String host = ChatClient.getInstance().kefuRestServer();
        final String tenantid = ChatClient.getInstance().tenantId();
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = host + "/v1/webimplugin/tenants/" + tenantid + "/robot-agents/" + robotAgentId + "/satisfaction-comment/tags";
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                    httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                    HttpRequestBuilder requestBuilder = httpClient.get(url);
                    requestBuilder.header("Content-Type", "application/json");
                    HttpResponse httpResponse = requestBuilder.execute();
                    if (httpResponse == null) {
                        if (callBack != null) {
                            callBack.onError(1, "response is null");
                        }
                        return;
                    }
                    int status_code = httpResponse.getStatusCode();
                    EMLog.d(KefuHttpClient.TAG, "dgetRobotQualityTags code:" + status_code);
                    if (status_code >= 200 && status_code < 300) {
                        StringBuffer buffer = new StringBuffer();
                        httpResponse.read(buffer);
                        String result = buffer.toString();
                        JSONObject response = new JSONObject(result);
                        JSONArray entities = response.getJSONArray("entities");
                        ArrayList<String> tags = new ArrayList<String>();
                        if (entities != null) {
                            for (int i = 0; i < entities.length(); ++i) {
                                JSONObject tag = entities.getJSONObject(i);
                                if (!tag.has("name")) continue;
                                tags.add(tag.getString("name"));
                            }
                        }
                        if (callBack != null) {
                            callBack.onSuccess(tags);
                        }
                    } else if (callBack != null) {
                        callBack.onError(1, "fetch tags fail");
                    }
                }
                catch (Exception e) {
                    callBack.onError(1, e.getMessage());
                }
            }
        });
    }

    private static JSONObject convertToMsgExt(JSONObject input) {
        JSONObject output = new JSONObject();
        try {
            if (input.has("menuItem")) {
                JSONObject menu = input.getJSONObject("menuItem");
                String itemName = null;
                JSONArray items = new JSONArray();
                if (menu.has("itemName")) {
                    itemName = menu.getString("itemName");
                }
                if (menu.has("children")) {
                    JSONArray children = menu.getJSONArray("children");
                    for (int i = 0; i < children.length(); ++i) {
                        JSONObject item = new JSONObject();
                        JSONObject c = children.getJSONObject(i);
                        if (c.has("itemId")) {
                            item.put("id", (Object)c.getString("itemId"));
                        }
                        if (c.has("itemName")) {
                            item.put("name", (Object)c.getString("itemName"));
                        }
                        if (c.has("queueId")) {
                            item.put("queueId", (Object)c.getString("queueId"));
                        }
                        if (c.has("queueType")) {
                            item.put("queueType", (Object)c.getString("queueType"));
                        }
                        if (c.has("queueName")) {
                            item.put("queueName", (Object)c.getString("queueName"));
                        }
                        items.put((Object)item);
                    }
                }
                if (menu.has("hasTransferNote") && menu.getBoolean("hasTransferNote")) {
                    JSONObject item = new JSONObject();
                    item.put("id", (Object)"hasTransferNote");
                    item.put("name", (Object)"\u7559\u8a00");
                    items.put((Object)item);
                }
                JSONObject choice = new JSONObject();
                choice.put("mode", (Object)"transferManualGuide");
                choice.put("items", (Object)items);
                choice.put("title", (Object)itemName);
                JSONObject msgtype = new JSONObject();
                msgtype.put("choice", (Object)choice);
                output.put("msgtype", (Object)msgtype);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public static void getTransferGuideMenu(final String conversationId, final ValueCallBack<JSONObject> callback) {
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block19: {
                    try {
                        String host = ChatClient.getInstance().kefuRestServer();
                        String tenantid = ChatClient.getInstance().tenantId();
                        if (TextUtils.isEmpty((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid cannot empty");
                            }
                            return;
                        }
                        if (!TextUtils.isDigitsOnly((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid must is digits");
                            }
                            return;
                        }
                        int pos = ChatClient.getInstance().appKey().indexOf("#");
                        int len = ChatClient.getInstance().appKey().length();
                        String orgName = ChatClient.getInstance().appKey().substring(0, pos);
                        String appkey = ChatClient.getInstance().appKey().substring(pos + 1, len);
                        String url_transfer_guide = "/v1/webimplugin/tenants/%s/welcome/transfer-manual-menu2";
                        String url = ChatClient.getInstance().kefuRestServer() + String.format(url_transfer_guide, tenantid);
                        url = url + "?orgName=";
                        url = url + orgName;
                        url = url + "&appName=";
                        url = url + appkey;
                        url = url + "&easeMobIMNumber=";
                        url = url + conversationId;
                        url = url + "&userName=";
                        url = url + ChatClient.getInstance().currentUserName();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(url);
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "getTransferGuideMenu status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callback != null) {
                                if (TextUtils.isEmpty((CharSequence)result)) {
                                    callback.onSuccess(null);
                                } else {
                                    JSONObject jsonObject = new JSONObject(result);
                                    JSONObject entity = null;
                                    if (jsonObject.has("entity")) {
                                        entity = jsonObject.getJSONObject("entity");
                                    }
                                    if (entity.has("resultSatus")) {
                                        if (entity.getString("resultSatus").equals("Ok")) {
                                            if (entity.has("menuItem")) {
                                                callback.onSuccess(KefuHttpClient.convertToMsgExt(entity));
                                            }
                                        } else {
                                            callback.onError(-1, entity.getString("resultMessage"));
                                        }
                                    } else {
                                        callback.onError(-1, "no entity");
                                    }
                                }
                            }
                        } else if (callback != null) {
                            callback.onError(-1, "getTransferGuideMenu from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block19;
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    public static void getEnterpriseWelcome(final ValueCallBack<String> callback) {
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block11: {
                    try {
                        String tenantid = ChatClient.getInstance().tenantId();
                        if (TextUtils.isEmpty((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid cannot empty");
                            }
                            return;
                        }
                        if (!TextUtils.isDigitsOnly((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid must is digits");
                            }
                            return;
                        }
                        String currentUser = ChatClient.getInstance().currentUserName();
                        String appkey = ChatClient.getInstance().appKey();
                        String token = ChatClient.getInstance().accessToken();
                        String url_welcome = "/v1/webimplugin/welcome?tenantId=%s&orgName=%s&appName=%s&userName=%s&token=%s";
                        String orgName = appkey.split("#")[0];
                        String appName = appkey.split("#")[1];
                        String url = ChatClient.getInstance().kefuRestServer() + String.format(url_welcome, tenantid, orgName, appName, currentUser, token);
                        url = KefuHttpClient.urlAppendSdkVersion(url);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        EMLog.d(KefuHttpClient.TAG, "getEnterpriseWelcome url:" + url);
                        HttpRequestBuilder requestBuilder = httpClient.get(url);
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "getEnterpriseWelcome status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callback != null) {
                                callback.onSuccess(result);
                            }
                        } else if (callback != null) {
                            callback.onError(-1, "getEnterpriseWelcome from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block11;
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    public static void getEnterpriseWelcome(final String visitorUserName, final ValueCallBack<String> callback) {
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block11: {
                    try {
                        String tenantid = ChatClient.getInstance().tenantId();
                        if (TextUtils.isEmpty((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid cannot empty");
                            }
                            return;
                        }
                        if (!TextUtils.isDigitsOnly((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid must is digits");
                            }
                            return;
                        }
                        String currentUser = ChatClient.getInstance().currentUserName();
                        String appkey = ChatClient.getInstance().appKey();
                        String token = ChatClient.getInstance().accessToken();
                        String url_welcome = "/v1/webimplugin/welcome?tenantId=%s&orgName=%s&appName=%s&userName=%s&token=%s&visitorUserName=%s";
                        String orgName = appkey.split("#")[0];
                        String appName = appkey.split("#")[1];
                        String url = ChatClient.getInstance().kefuRestServer() + String.format(url_welcome, tenantid, orgName, appName, currentUser, token, visitorUserName);
                        url = KefuHttpClient.urlAppendSdkVersion(url);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(url);
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "getEnterpriseWelcome status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callback != null) {
                                callback.onSuccess(result);
                            }
                        } else if (callback != null) {
                            callback.onError(-1, "getEnterpriseWelcome from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block11;
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    public static void getAppRelevanceEnterpriseWelcomeWithVisitorUserName(final String easeMobIMNumber, final String visitorUserName, final ValueCallBack<String> callback) {
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block11: {
                    try {
                        String tenantid = ChatClient.getInstance().tenantId();
                        if (TextUtils.isEmpty((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid cannot empty");
                            }
                            return;
                        }
                        if (!TextUtils.isDigitsOnly((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid must is digits");
                            }
                            return;
                        }
                        String currentUser = ChatClient.getInstance().currentUserName();
                        String appkey = ChatClient.getInstance().appKey();
                        String token = ChatClient.getInstance().accessToken();
                        String url_welcome = "/v1/webimplugin/welcome?tenantId=%s&orgName=%s&appName=%s&userName=%s&token=%s&visitorUserName=%s&easeMobIMNumber=%s";
                        String orgName = appkey.split("#")[0];
                        String appName = appkey.split("#")[1];
                        String url = ChatClient.getInstance().kefuRestServer() + String.format(url_welcome, tenantid, orgName, appName, currentUser, token, visitorUserName, easeMobIMNumber);
                        url = KefuHttpClient.urlAppendSdkVersion(url);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(url);
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "getEnterpriseWelcome status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callback != null) {
                                callback.onSuccess(result);
                            }
                        } else if (callback != null) {
                            callback.onError(-1, "getEnterpriseWelcome from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block11;
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    public static void asyncCancelVideoConferences(final String sessionId, final ValueCallBack<String> callBack) {
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block11: {
                    try {
                        if (TextUtils.isEmpty((CharSequence)sessionId)) {
                            if (callBack != null) {
                                callBack.onError(-1, "sessionId cannot be empty");
                            }
                            return;
                        }
                        String tenantid = ChatClient.getInstance().tenantId();
                        if (TextUtils.isEmpty((CharSequence)tenantid)) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid cannot be empty");
                            }
                            return;
                        }
                        if (!TextUtils.isDigitsOnly((CharSequence)tenantid)) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid must is digits");
                            }
                            return;
                        }
                        String url_session = "/v1/rtcmedia/serviceSession/%s/conferences";
                        String url = ChatClient.getInstance().kefuRestServer() + String.format(url_session, sessionId);
                        url = KefuHttpClient.urlAppendSdkVersion(url);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.delete(url);
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "getCurrentSessionStatus status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callBack == null) break block11;
                        callBack.onError(-1, e.getMessage() + "");
                    }
                }
            }
        });
    }

    public static void getCurrentSessionId(final String toChatUsername, final ValueCallBack<String> callback) {
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block15: {
                    try {
                        if (TextUtils.isEmpty((CharSequence)toChatUsername)) {
                            if (callback != null) {
                                callback.onError(-1, "IMServiceNumber cannot be empty");
                            }
                            return;
                        }
                        String tenantid = ChatClient.getInstance().tenantId();
                        if (TextUtils.isEmpty((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid cannot be empty");
                            }
                            return;
                        }
                        if (!TextUtils.isDigitsOnly((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid must is digits");
                            }
                            return;
                        }
                        String currentUser = ChatClient.getInstance().currentUserName();
                        if (TextUtils.isEmpty((CharSequence)currentUser)) {
                            if (callback != null) {
                                callback.onError(-1, "please login first");
                            }
                            return;
                        }
                        String appkey = ChatClient.getInstance().appKey();
                        String techChannelInfo = appkey + "#" + toChatUsername;
                        techChannelInfo = techChannelInfo.replace("#", "%23");
                        String token = ChatClient.getInstance().accessToken();
                        String orgName = appkey.split("#")[0];
                        String appName = appkey.split("#")[1];
                        String url_session = "/tenantapi/visitors/%1$s/specificServiceSessionIds?states=Processing,Wait&techChannelInfo=%2$s&tenantId=%3$s&orgName=%4$s&appName=%5$s&userName=%6$s&token=%7$s";
                        String url = ChatClient.getInstance().kefuRestServer() + String.format(url_session, currentUser, techChannelInfo, tenantid, orgName, appName, currentUser, token);
                        url = KefuHttpClient.urlAppendSdkVersion(url);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(url);
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "getCurrentSessionId status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callback != null) {
                                callback.onSuccess(result);
                            }
                        } else if (callback != null) {
                            callback.onError(-1, "getCurrentSessionId from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block15;
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    public static void getCurrentSession(final String toChatUsername, final ValueCallBack<String> callback) {
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block15: {
                    try {
                        if (TextUtils.isEmpty((CharSequence)toChatUsername)) {
                            if (callback != null) {
                                callback.onError(-1, "IMServiceNumber cannot be empty");
                            }
                            return;
                        }
                        String tenantid = ChatClient.getInstance().tenantId();
                        if (TextUtils.isEmpty((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid cannot be empty");
                            }
                            return;
                        }
                        if (!TextUtils.isDigitsOnly((CharSequence)tenantid)) {
                            if (callback != null) {
                                callback.onError(-1, "tenantid must is digits");
                            }
                            return;
                        }
                        String currentUser = ChatClient.getInstance().currentUserName();
                        if (TextUtils.isEmpty((CharSequence)currentUser)) {
                            if (callback != null) {
                                callback.onError(-1, "please login first");
                            }
                            return;
                        }
                        String appkey = ChatClient.getInstance().appKey();
                        String techChannelInfo = appkey + "#" + toChatUsername;
                        techChannelInfo = techChannelInfo.replace("#", "%23");
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/webimplugin/tenant/%2$s/visitors/%3$s/CurrentServiceSession?techChannelInfo=%4$s", urlRoot, tenantid, currentUser, techChannelInfo);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "getCurrentSession status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callback != null) {
                                callback.onSuccess(result);
                            }
                        } else if (callback != null) {
                            callback.onError(-1, "getCurrentSession from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block15;
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    public static void sendVecMessageByKefuRest(boolean isReSend, String rtcSessionId, String visitorId, Message message, EMCallBack callBack) {
        if (!ChatClient.getInstance().isLoggedInBefore()) {
            if (callBack != null) {
                callBack.onError(201, "user no login");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)ChatClient.getInstance().tenantId())) {
            if (callBack != null) {
                callBack.onError(500, "tenantId is not set");
            }
            return;
        }
        if (message.getType() == Message.Type.TXT) {
            KefuHttpClient.sendVecTxtMessageByKefuRest(isReSend, rtcSessionId, visitorId, message, callBack);
        } else if (message.getType() == Message.Type.IMAGE) {
            KefuHttpClient.sendVecImageMessageByKefuRest(isReSend, rtcSessionId, visitorId, message, callBack);
        } else if (message.getType() == Message.Type.FILE) {
            KefuHttpClient.sendVecFileMessageByKefuRest(isReSend, rtcSessionId, visitorId, message, callBack);
        } else if (message.getType() == Message.Type.VIDEO) {
            KefuHttpClient.sendVecVideoMessageByKefuRest(isReSend, rtcSessionId, visitorId, message, callBack);
        } else if (callBack != null) {
            callBack.onError(1, "no support message type");
        }
    }

    private static void sendVecTxtMessageByKefuRest(final boolean isReSend, final String rtcSessionId, final String visitorId, final Message message, final EMCallBack callBack) {
        final EMTextMessageBody textMessageBody = (EMTextMessageBody)message.body();
        EMLog.e(TAG, "vec sendMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block23: {
                    String kefuHost = ChatClient.getInstance().kefuRestServer();
                    String tenantId = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty((CharSequence)tenantId)) {
                        if (callBack != null) {
                            callBack.onError(500, "tenantId is not set");
                        }
                        return;
                    }
                    String remoteUrl = String.format("%1$s/v1/kefurtc/tenant/%2$s/session/%3$s/visitor/%4$s/messages", kefuHost, tenantId, rtcSessionId, visitorId);
                    try {
                        JSONObject bodyJson = new JSONObject();
                        JSONObject extJson = new JSONObject(message.attributes);
                        bodyJson.put("from", (Object)ChatClient.getInstance().currentUserName());
                        bodyJson.put("action", (Object)"");
                        bodyJson.put("audioLength", 0);
                        bodyJson.put("channelId", 0);
                        bodyJson.put("duration", (Object)"");
                        bodyJson.put("ext", (Object)extJson);
                        bodyJson.put("fileLength", 0);
                        bodyJson.put("filename", (Object)"");
                        bodyJson.put("flowId", 0);
                        bodyJson.put("fromUserId", (Object)"");
                        bodyJson.put("fromUserName", (Object)(TextUtils.isEmpty((CharSequence)message.getVecUserName()) ? "" : message.getVecUserName()));
                        bodyJson.put("imageHeight", 0);
                        bodyJson.put("imageWidth", 0);
                        bodyJson.put("latitude", (Object)"");
                        bodyJson.put("longitude", (Object)"");
                        bodyJson.put("length", 0);
                        bodyJson.put("mediaFileUrl", (Object)"");
                        bodyJson.put("mediaId", (Object)"");
                        bodyJson.put("msg", (Object)textMessageBody.getMessage());
                        bodyJson.put("recognition", (Object)"");
                        bodyJson.put("rtcSessionId", (Object)rtcSessionId);
                        bodyJson.put("sendTime", message.messageTime());
                        bodyJson.put("serviceSessionId", (Object)"");
                        bodyJson.put("tenantId", (Object)tenantId);
                        bodyJson.put("thumb", (Object)"");
                        bodyJson.put("thumbSecret", (Object)"");
                        bodyJson.put("toUser", (Object)"");
                        bodyJson.put("toUserId", (Object)"");
                        bodyJson.put("type", (Object)"txt");
                        bodyJson.put("url", (Object)"");
                        if (!isReSend) {
                            VecDatabaseManager.getInstance().updateMessageBodyContent(rtcSessionId, message, bodyJson);
                        }
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        requestBuilder.header("Content-Type", "application/json");
                        requestBuilder.content(bodyJson.toString().getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "rest status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            JSONObject jsonResult = new JSONObject(result);
                            String statusParam = jsonResult.getString("status");
                            if (statusParam.equalsIgnoreCase("OK")) {
                                EMLog.d(KefuHttpClient.TAG, "rest status_code :ok");
                                if (callBack != null) {
                                    callBack.onSuccess();
                                    return;
                                }
                            } else if (statusParam.equalsIgnoreCase("FAIL")) {
                                if (result.contains("duplicated message") || result.contains("im_routeway_partner_002")) {
                                    EMLog.d(KefuHttpClient.TAG, "rest status_code: duplicated message");
                                    if (callBack != null) {
                                        callBack.onSuccess();
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_001")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "Can not find channel, please check appkey & im service num.");
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_003")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "Server Got an exception");
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_004")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "Got bodies exception");
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_005")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "msg_id_for_ack is blank.");
                                    }
                                    return;
                                }
                                if (callBack != null) {
                                    callBack.onError(1, "result:" + result);
                                }
                                return;
                            }
                            EMLog.d(KefuHttpClient.TAG, "rest status_code: FAIL :" + status_code);
                            if (callBack != null) {
                                callBack.onError(1, "statusCode:" + status_code);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callBack == null) break block23;
                        callBack.onError(1, "error:" + e.getMessage());
                    }
                }
            }
        });
    }

    private static void sendVecImageMessageByKefuRest(final boolean isReSend, final String rtcSessionId, final String visitorId, final Message message, final EMCallBack callback) {
        final EMImageMessageBody imageMessageBody = (EMImageMessageBody)message.body();
        EMLog.e(TAG, "vec sendImageMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    final String localPath = imageMessageBody.getLocalUrl();
                    File file = new File(localPath);
                    if (!file.exists()) {
                        if (callback != null) {
                            callback.onError(400, "file not found");
                        }
                        return;
                    }
                    String appKey = ChatClient.getInstance().appKey();
                    if (appKey == null) {
                        EMLog.e(KefuHttpClient.TAG, "appkey is not set");
                        if (callback != null) {
                            callback.onError(100, "appkey is not set");
                        }
                        return;
                    }
                    try {
                        String uploadUrl = KefuHttpClient.getVecUploadMediaFileUrl();
                        KefuHttpClient.uploadVecAttachment(uploadUrl, localPath, new HttpResponseHandler(){

                            @Override
                            public void onTimeout() throws Exception {
                                if (callback != null) {
                                    callback.onError(301, "server timeout.");
                                }
                            }

                            @Override
                            public void onResponse(HttpResponse response, long contentLength) throws Exception {
                                String result = response.getResponseBody();
                                JSONObject jsonObject = new JSONObject(result);
                                String fileName = jsonObject.getString("fileName");
                                String mediaId = jsonObject.getString("uuid");
                                long length = jsonObject.getLong("contentLength");
                                String remoteUrl = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                                String kefuHost = ChatClient.getInstance().kefuRestServer();
                                String tenantId = ChatClient.getInstance().tenantId();
                                if (TextUtils.isEmpty((CharSequence)tenantId)) {
                                    if (callback != null) {
                                        callback.onError(500, "tenantId is not set");
                                    }
                                    return;
                                }
                                BitmapFactory.Options options = ImageUtils.getBitmapOptions(localPath);
                                int width = options.outWidth;
                                int height = options.outHeight;
                                String messageUrl = String.format("%1$s/v1/kefurtc/tenant/%2$s/session/%3$s/visitor/%4$s/messages", kefuHost, tenantId, rtcSessionId, visitorId);
                                JSONObject bodyJson = new JSONObject();
                                JSONObject extJson = new JSONObject(message.attributes);
                                bodyJson.put("from", (Object)ChatClient.getInstance().currentUserName());
                                bodyJson.put("action", (Object)"");
                                bodyJson.put("audioLength", 0);
                                bodyJson.put("channelId", 0);
                                bodyJson.put("duration", (Object)"");
                                bodyJson.put("ext", (Object)extJson);
                                bodyJson.put("fileLength", length);
                                bodyJson.put("filename", (Object)URLEncoder.encode(fileName, "utf-8"));
                                bodyJson.put("flowId", 0);
                                bodyJson.put("fromUserId", (Object)"");
                                bodyJson.put("fromUserName", (Object)(TextUtils.isEmpty((CharSequence)message.getVecUserName()) ? "" : message.getVecUserName()));
                                bodyJson.put("imageHeight", height);
                                bodyJson.put("imageWidth", width);
                                bodyJson.put("latitude", (Object)"");
                                bodyJson.put("longitude", (Object)"");
                                bodyJson.put("length", 0);
                                bodyJson.put("mediaFileUrl", (Object)"");
                                bodyJson.put("mediaId", (Object)mediaId);
                                bodyJson.put("msg", (Object)"");
                                bodyJson.put("recognition", (Object)"");
                                bodyJson.put("rtcSessionId", (Object)rtcSessionId);
                                bodyJson.put("sendTime", message.messageTime());
                                bodyJson.put("serviceSessionId", (Object)"");
                                bodyJson.put("tenantId", (Object)tenantId);
                                bodyJson.put("thumb", (Object)imageMessageBody.getThumbnailUrl());
                                bodyJson.put("thumbSecret", (Object)imageMessageBody.getThumbnailSecret());
                                bodyJson.put("toUser", (Object)"");
                                bodyJson.put("toUserId", (Object)"");
                                bodyJson.put("type", (Object)"img");
                                bodyJson.put("url", (Object)remoteUrl);
                                if (!isReSend) {
                                    VecDatabaseManager.getInstance().updateMessageBodyContent(rtcSessionId, message, bodyJson);
                                }
                                HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
                                httpClient1.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                                httpClient1.setReadTimeout(DEFAULT_READ_TIMEOUT);
                                HttpRequestBuilder requestBuilder1 = httpClient1.post(messageUrl);
                                requestBuilder1.content(bodyJson.toString().getBytes(), "application/json");
                                HttpResponse msgHttpResponse = requestBuilder1.execute();
                                assert (msgHttpResponse != null);
                                String msgResult = msgHttpResponse.getResponseBody();
                                EMLog.d(KefuHttpClient.TAG, "msg result:" + msgResult);
                                JSONObject jsonResult = new JSONObject(msgResult);
                                String statusParam = jsonResult.getString("status");
                                if (statusParam.equalsIgnoreCase("Ok")) {
                                    if (callback != null) {
                                        imageMessageBody.setRemoteUrl(remoteUrl);
                                        imageMessageBody.setThumbnailUrl(remoteUrl);
                                        callback.onSuccess();
                                        return;
                                    }
                                } else if (statusParam.equalsIgnoreCase("FAIL")) {
                                    if (msgResult.contains("duplicated message") || msgResult.contains("im_routeway_partner_002")) {
                                        EMLog.d(KefuHttpClient.TAG, "rest status_code: duplicated message");
                                        if (callback != null) {
                                            imageMessageBody.setThumbnailUrl(remoteUrl);
                                            imageMessageBody.setRemoteUrl(remoteUrl);
                                            callback.onSuccess();
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_001")) {
                                        if (callback != null) {
                                            callback.onError(1, "Can not find channel, please check appkey & im service num.");
                                        }
                                        return;
                                    }
                                    if (msgResult.contains("im_routeway_partner_003")) {
                                        if (callback != null) {
                                            callback.onError(1, "Server Got an exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_004")) {
                                        if (callback != null) {
                                            callback.onError(1, "Got bodies exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_005")) {
                                        if (callback != null) {
                                            callback.onError(1, "msg_id_for_ack is blank.");
                                        }
                                        return;
                                    }
                                    if (callback != null) {
                                        callback.onError(1, "result:" + msgResult);
                                    }
                                    return;
                                }
                                if (callback != null) {
                                    callback.onError(1, "result :" + msgResult);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        EMLog.e(KefuHttpClient.TAG, "e:" + e.getMessage());
                        if (callback == null) break block6;
                        callback.onError(1, "error:" + e.getMessage());
                    }
                }
            }
        });
    }

    private static void sendVecVoiceMessageByKefuRest(final Message message, final EMCallBack callback) {
        final EMVoiceMessageBody voiceMessageBody = (EMVoiceMessageBody)message.body();
        EMLog.d(TAG, "sendVoiceMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    String localPath = voiceMessageBody.getLocalUrl();
                    File file = new File(localPath);
                    if (!file.exists()) {
                        if (callback != null) {
                            callback.onError(400, "file not found");
                        }
                        return;
                    }
                    String appKey = ChatClient.getInstance().appKey();
                    if (appKey == null) {
                        EMLog.e(KefuHttpClient.TAG, "appkey is not set");
                        if (callback != null) {
                            callback.onError(100, "appkey is not set");
                        }
                        return;
                    }
                    try {
                        final String orgName = appKey.split("#")[0];
                        final String appName = appKey.split("#")[1];
                        final String currentUserName = ChatClient.getInstance().currentUserName();
                        String uploadUrl = KefuHttpClient.getUploadMediaFileUrl(orgName, appName, currentUserName);
                        KefuHttpClient.uploadAttachment(uploadUrl, localPath, new HttpResponseHandler(){

                            @Override
                            public void onTimeout() throws Exception {
                                if (callback != null) {
                                    callback.onError(301, "server timeout.");
                                }
                            }

                            @Override
                            public void onResponse(HttpResponse response, long contentLength) throws Exception {
                                String result = response.getResponseBody();
                                JSONObject jsonObject = new JSONObject(result);
                                String fileName = jsonObject.getString("fileName");
                                String remoteUrl = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                                String messageUrl = KefuHttpClient.getSendMessageUrl();
                                JSONObject bodyJson = new JSONObject();
                                JSONObject extJson = new JSONObject(message.attributes);
                                bodyJson.put("from", (Object)currentUserName);
                                bodyJson.put("to", (Object)message.to());
                                JSONArray jsonMsgBodyArr = new JSONArray();
                                JSONObject jsonMsgBody = new JSONObject();
                                jsonMsgBody.put("type", (Object)"audio");
                                jsonMsgBody.put("url", (Object)remoteUrl);
                                jsonMsgBody.put("filename", (Object)fileName);
                                jsonMsgBody.put("length", voiceMessageBody.getLength());
                                jsonMsgBodyArr.put((Object)jsonMsgBody);
                                bodyJson.put("bodies", (Object)jsonMsgBodyArr);
                                bodyJson.put("originType", (Object)"app");
                                bodyJson.put("orgName", (Object)orgName);
                                bodyJson.put("appName", (Object)appName);
                                bodyJson.put("ext", (Object)extJson);
                                HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
                                httpClient1.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                                httpClient1.setReadTimeout(DEFAULT_READ_TIMEOUT);
                                HttpRequestBuilder requestBuilder1 = httpClient1.post(messageUrl);
                                requestBuilder1.content(bodyJson.toString().getBytes(), "application/json");
                                HttpResponse msgHttpResponse = requestBuilder1.execute();
                                assert (msgHttpResponse != null);
                                String msgResult = msgHttpResponse.getResponseBody();
                                EMLog.d(KefuHttpClient.TAG, "msg result:" + msgResult);
                                JSONObject jsonResult = new JSONObject(msgResult);
                                String statusParam = jsonResult.getString("status");
                                if (statusParam.equalsIgnoreCase("Ok")) {
                                    if (callback != null) {
                                        voiceMessageBody.setRemoteUrl(remoteUrl);
                                        callback.onSuccess();
                                        return;
                                    }
                                } else if (statusParam.equalsIgnoreCase("FAIL")) {
                                    if (msgResult.contains("duplicated message") || msgResult.contains("im_routeway_partner_002")) {
                                        EMLog.d(KefuHttpClient.TAG, "rest status_code: duplicated message");
                                        if (callback != null) {
                                            voiceMessageBody.setRemoteUrl(remoteUrl);
                                            callback.onSuccess();
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_001")) {
                                        if (callback != null) {
                                            callback.onError(1, "Can not find channel, please check appkey & im service num.");
                                        }
                                        return;
                                    }
                                    if (msgResult.contains("im_routeway_partner_003")) {
                                        if (callback != null) {
                                            callback.onError(1, "Server Got an exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_004")) {
                                        if (callback != null) {
                                            callback.onError(1, "Got bodies exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_005")) {
                                        if (callback != null) {
                                            callback.onError(1, "msg_id_for_ack is blank.");
                                        }
                                        return;
                                    }
                                    if (callback != null) {
                                        callback.onError(1, "result:" + msgResult);
                                    }
                                    return;
                                }
                                if (callback != null) {
                                    callback.onError(1, "result :" + msgResult);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        EMLog.e(KefuHttpClient.TAG, "e:" + e.getMessage());
                        if (callback == null) break block6;
                        callback.onError(1, "error:" + e.getMessage());
                    }
                }
            }
        });
    }

    private static void sendVecFileMessageByKefuRest(final boolean isReSend, final String rtcSessionId, final String visitorId, final Message message, final EMCallBack callback) {
        final EMNormalFileMessageBody fileMessageBody = (EMNormalFileMessageBody)message.body();
        EMLog.e(TAG, "vec sendFileMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block7: {
                    File file;
                    String localPath = fileMessageBody.getLocalUrl();
                    if (!UriUtils.isFileExistByUri(EMClient.getInstance().getContext(), fileMessageBody.getLocalUri())) {
                        EMLog.e(KefuHttpClient.TAG, "file does not exist");
                    }
                    if (!(file = new File(localPath)).exists()) {
                        EMLog.e(KefuHttpClient.TAG, "file does not exist");
                        if (callback != null) {
                            callback.onError(400, "file not found");
                        }
                        return;
                    }
                    String appKey = ChatClient.getInstance().appKey();
                    if (appKey == null) {
                        EMLog.e(KefuHttpClient.TAG, "appkey is not set");
                        if (callback != null) {
                            callback.onError(100, "appkey is not set");
                        }
                        return;
                    }
                    try {
                        String uploadUrl = KefuHttpClient.getVecUploadMediaFileUrl();
                        KefuHttpClient.uploadVecAttachment(uploadUrl, localPath, new HttpResponseHandler(){

                            @Override
                            public void onTimeout() throws Exception {
                                if (callback != null) {
                                    callback.onError(301, "server timeout.");
                                }
                            }

                            @Override
                            public void onResponse(HttpResponse response, long contentLength) throws Exception {
                                String result = response.getResponseBody();
                                JSONObject jsonObject = new JSONObject(result);
                                String fileName = jsonObject.getString("fileName");
                                String mediaId = jsonObject.optString("uuid");
                                String remoteUrl = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                                String kefuHost = ChatClient.getInstance().kefuRestServer();
                                String tenantId = ChatClient.getInstance().tenantId();
                                if (TextUtils.isEmpty((CharSequence)tenantId)) {
                                    if (callback != null) {
                                        callback.onError(500, "tenantId is not set");
                                    }
                                    return;
                                }
                                String messageUrl = String.format("%1$s/v1/kefurtc/tenant/%2$s/session/%3$s/visitor/%4$s/messages", kefuHost, tenantId, rtcSessionId, visitorId);
                                JSONObject bodyJson = new JSONObject();
                                JSONObject extJson = new JSONObject(message.attributes);
                                bodyJson.put("from", (Object)ChatClient.getInstance().currentUserName());
                                bodyJson.put("action", (Object)"");
                                bodyJson.put("audioLength", 0);
                                bodyJson.put("channelId", 0);
                                bodyJson.put("duration", (Object)"");
                                bodyJson.put("ext", (Object)extJson);
                                bodyJson.put("fileLength", file.length());
                                bodyJson.put("filename", (Object)URLEncoder.encode(fileName, "utf-8"));
                                bodyJson.put("flowId", 0);
                                bodyJson.put("fromUserId", (Object)"");
                                bodyJson.put("fromUserName", (Object)(TextUtils.isEmpty((CharSequence)message.getVecUserName()) ? "" : message.getVecUserName()));
                                bodyJson.put("imageHeight", 0);
                                bodyJson.put("imageWidth", 0);
                                bodyJson.put("latitude", (Object)"");
                                bodyJson.put("longitude", (Object)"");
                                bodyJson.put("length", file.length());
                                bodyJson.put("mediaFileUrl", (Object)"");
                                bodyJson.put("mediaId", (Object)mediaId);
                                bodyJson.put("msg", (Object)"");
                                bodyJson.put("recognition", (Object)"");
                                bodyJson.put("rtcSessionId", (Object)rtcSessionId);
                                bodyJson.put("sendTime", message.messageTime());
                                bodyJson.put("serviceSessionId", (Object)"");
                                bodyJson.put("tenantId", (Object)tenantId);
                                bodyJson.put("thumb", (Object)"");
                                bodyJson.put("thumbSecret", (Object)"");
                                bodyJson.put("toUser", (Object)"");
                                bodyJson.put("toUserId", (Object)"");
                                bodyJson.put("type", (Object)"file");
                                bodyJson.put("url", (Object)remoteUrl);
                                if (!isReSend) {
                                    VecDatabaseManager.getInstance().updateMessageBodyContent(rtcSessionId, message, bodyJson);
                                }
                                EMLog.e(KefuHttpClient.TAG, "vec send bodyJson = " + bodyJson);
                                Log.e("oooooooooo", "vec send bodyJson = " + bodyJson);
                                HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
                                httpClient1.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                                httpClient1.setReadTimeout(DEFAULT_READ_TIMEOUT);
                                HttpRequestBuilder requestBuilder1 = httpClient1.post(messageUrl);
                                requestBuilder1.content(bodyJson.toString().getBytes(), "application/json");
                                HttpResponse msgHttpResponse = requestBuilder1.execute();
                                assert (msgHttpResponse != null);
                                String msgResult = msgHttpResponse.getResponseBody();
                                EMLog.d(KefuHttpClient.TAG, "msg result:" + msgResult);
                                JSONObject jsonResult = new JSONObject(msgResult);
                                String statusParam = jsonResult.getString("status");
                                if (statusParam.equalsIgnoreCase("Ok")) {
                                    if (callback != null) {
                                        fileMessageBody.setRemoteUrl(remoteUrl);
                                        callback.onSuccess();
                                        return;
                                    }
                                } else if (statusParam.equalsIgnoreCase("FAIL")) {
                                    if (msgResult.contains("duplicated message") || msgResult.contains("im_routeway_partner_002")) {
                                        EMLog.d(KefuHttpClient.TAG, "rest status_code: duplicated message");
                                        if (callback != null) {
                                            fileMessageBody.setRemoteUrl(remoteUrl);
                                            callback.onSuccess();
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_001")) {
                                        if (callback != null) {
                                            callback.onError(1, "Can not find channel, please check appkey & im service num.");
                                        }
                                        return;
                                    }
                                    if (msgResult.contains("im_routeway_partner_003")) {
                                        if (callback != null) {
                                            callback.onError(1, "Server Got an exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_004")) {
                                        if (callback != null) {
                                            callback.onError(1, "Got bodies exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_005")) {
                                        if (callback != null) {
                                            callback.onError(1, "msg_id_for_ack is blank.");
                                        }
                                        return;
                                    }
                                    if (callback != null) {
                                        callback.onError(1, "result:" + msgResult);
                                    }
                                    return;
                                }
                                if (callback != null) {
                                    callback.onError(1, "result :" + msgResult);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block7;
                        callback.onError(1, "result :" + e.getMessage());
                    }
                }
            }
        });
    }

    private static void sendVecVideoMessageByKefuRest(final boolean isReSend, final String rtcSessionId, final String visitorId, final Message message, final EMCallBack callback) {
        final EMVideoMessageBody videoMessageBody = (EMVideoMessageBody)message.body();
        EMLog.e(TAG, "vec sendVideoMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                String thumbnailUrl = videoMessageBody.getLocalThumb();
                File thumbnail = new File(thumbnailUrl);
                if (!thumbnail.exists()) {
                    if (callback != null) {
                        callback.onError(400, "thumbnail file not found");
                    }
                    return;
                }
                String localPath = videoMessageBody.getLocalUrl();
                final File file = new File(localPath);
                if (!file.exists()) {
                    if (callback != null) {
                        callback.onError(400, "file not found");
                    }
                    return;
                }
                String appKey = ChatClient.getInstance().appKey();
                if (appKey == null) {
                    EMLog.e(KefuHttpClient.TAG, "appkey is not set");
                    if (callback != null) {
                        callback.onError(100, "appkey is not set");
                    }
                    return;
                }
                String uploadUrl = KefuHttpClient.getVecUploadMediaFileUrl();
                MarketingHttpClient.uploadVecFile(uploadUrl, localPath, new ValueCallBack<String>(){

                    @Override
                    public void onSuccess(String result) {
                        block24: {
                            try {
                                String url;
                                JSONObject jsonObject = new JSONObject(result);
                                String fileName = jsonObject.getString("fileName");
                                String thumbnail = jsonObject.optString("thumbnail");
                                if (!TextUtils.isEmpty((CharSequence)thumbnail) && !thumbnail.startsWith("http")) {
                                    thumbnail = ChatClient.getInstance().kefuRestServer() + thumbnail;
                                }
                                if (!(url = jsonObject.getString("url")).startsWith("http")) {
                                    url = ChatClient.getInstance().kefuRestServer() + jsonObject.getString("url");
                                }
                                String mediaId = jsonObject.optString("uuid");
                                String kefuHost = ChatClient.getInstance().kefuRestServer();
                                String tenantId = ChatClient.getInstance().tenantId();
                                if (TextUtils.isEmpty((CharSequence)tenantId)) {
                                    if (callback != null) {
                                        callback.onError(500, "tenantId is not set");
                                    }
                                    return;
                                }
                                String messageUrl = String.format("%1$s/v1/kefurtc/tenant/%2$s/session/%3$s/visitor/%4$s/messages", kefuHost, tenantId, rtcSessionId, visitorId);
                                JSONObject bodyJson = new JSONObject();
                                JSONObject extJson = new JSONObject(message.attributes);
                                bodyJson.put("from", (Object)ChatClient.getInstance().currentUserName());
                                bodyJson.put("action", (Object)"");
                                bodyJson.put("audioLength", 0);
                                bodyJson.put("channelId", 0);
                                bodyJson.put("duration", (Object)"");
                                bodyJson.put("ext", (Object)extJson);
                                bodyJson.put("fileLength", file.length());
                                bodyJson.put("filename", (Object)URLEncoder.encode(fileName, "utf-8"));
                                bodyJson.put("flowId", 0);
                                bodyJson.put("fromUserId", (Object)"");
                                bodyJson.put("fromUserName", (Object)(TextUtils.isEmpty((CharSequence)message.getVecUserName()) ? "" : message.getVecUserName()));
                                bodyJson.put("imageHeight", 0);
                                bodyJson.put("imageWidth", 0);
                                bodyJson.put("latitude", (Object)"");
                                bodyJson.put("longitude", (Object)"");
                                bodyJson.put("length", file.length());
                                bodyJson.put("mediaFileUrl", (Object)"");
                                bodyJson.put("mediaId", (Object)mediaId);
                                bodyJson.put("msg", (Object)"");
                                bodyJson.put("recognition", (Object)"");
                                bodyJson.put("rtcSessionId", (Object)rtcSessionId);
                                bodyJson.put("sendTime", message.messageTime());
                                bodyJson.put("serviceSessionId", (Object)"");
                                bodyJson.put("tenantId", (Object)tenantId);
                                bodyJson.put("thumb", (Object)thumbnail);
                                bodyJson.put("thumbSecret", (Object)videoMessageBody.getThumbnailSecret());
                                bodyJson.put("toUser", (Object)"");
                                bodyJson.put("toUserId", (Object)"");
                                bodyJson.put("type", (Object)"video");
                                bodyJson.put("url", (Object)url);
                                if (!isReSend) {
                                    VecDatabaseManager.getInstance().updateMessageBodyContent(rtcSessionId, message, bodyJson);
                                }
                                HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
                                httpClient1.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                                httpClient1.setReadTimeout(DEFAULT_READ_TIMEOUT);
                                HttpRequestBuilder requestBuilder1 = httpClient1.post(messageUrl);
                                requestBuilder1.content(bodyJson.toString().getBytes(), "application/json");
                                HttpResponse msgHttpResponse = requestBuilder1.execute();
                                assert (msgHttpResponse != null);
                                String msgResult = msgHttpResponse.getResponseBody();
                                EMLog.d(KefuHttpClient.TAG, "msg result:" + msgResult);
                                JSONObject jsonResult = new JSONObject(msgResult);
                                String statusParam = jsonResult.getString("status");
                                if (statusParam.equalsIgnoreCase("Ok")) {
                                    if (callback != null) {
                                        videoMessageBody.setRemoteUrl(url);
                                        callback.onSuccess();
                                        return;
                                    }
                                } else if (statusParam.equalsIgnoreCase("FAIL")) {
                                    if (msgResult.contains("duplicated message") || msgResult.contains("im_routeway_partner_002")) {
                                        EMLog.d(KefuHttpClient.TAG, "rest status_code: duplicated message");
                                        if (callback != null) {
                                            videoMessageBody.setRemoteUrl(url);
                                            callback.onSuccess();
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_001")) {
                                        if (callback != null) {
                                            callback.onError(1, "Can not find channel, please check appkey & im service num.");
                                        }
                                        return;
                                    }
                                    if (msgResult.contains("im_routeway_partner_003")) {
                                        if (callback != null) {
                                            callback.onError(1, "Server Got an exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_004")) {
                                        if (callback != null) {
                                            callback.onError(1, "Got bodies exception");
                                        }
                                        return;
                                    }
                                    if (result.contains("im_routeway_partner_005")) {
                                        if (callback != null) {
                                            callback.onError(1, "msg_id_for_ack is blank.");
                                        }
                                        return;
                                    }
                                    if (callback != null) {
                                        callback.onError(1, "result:" + msgResult);
                                    }
                                    return;
                                }
                                if (callback != null) {
                                    callback.onError(1, "result :" + msgResult);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if (callback == null) break block24;
                                callback.onError(-1, e.getMessage());
                            }
                        }
                    }

                    @Override
                    public void onError(int error, String errorMsg) {
                        EMLog.e(KefuHttpClient.TAG, "errorMsg = " + errorMsg);
                        if (callback != null) {
                            callback.onError(301, "server timeout.");
                        }
                    }
                });
            }
        });
    }

    private static void sendVecCmdMessageByKefuRest(final Message message, final EMCallBack callBack) {
        final EMCmdMessageBody messageBody = (EMCmdMessageBody)message.body();
        EMLog.d(TAG, "sendCmdMessageByKefuRest msgId:" + message.messageId());
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block21: {
                    String remoteUrl = KefuHttpClient.getSendMessageUrl();
                    try {
                        String appKey = ChatClient.getInstance().appKey();
                        if (appKey == null) {
                            EMLog.e(KefuHttpClient.TAG, "send message appkey is null");
                            return;
                        }
                        String orgName = appKey.split("#")[0];
                        String appName = appKey.split("#")[1];
                        JSONObject bodyJson = new JSONObject();
                        JSONObject extJson = new JSONObject(message.attributes);
                        bodyJson.put("from", (Object)ChatClient.getInstance().currentUserName());
                        bodyJson.put("to", (Object)message.to());
                        JSONArray jsonMsgBodyArr = new JSONArray();
                        JSONObject jsonMsgBody = new JSONObject();
                        jsonMsgBody.put("type", (Object)"cmd");
                        jsonMsgBody.put("action", (Object)messageBody.action());
                        jsonMsgBodyArr.put((Object)jsonMsgBody);
                        bodyJson.put("bodies", (Object)jsonMsgBodyArr);
                        bodyJson.put("originType", (Object)"app");
                        bodyJson.put("orgName", (Object)orgName);
                        bodyJson.put("appName", (Object)appName);
                        bodyJson.put("ext", (Object)extJson);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        requestBuilder.header("Content-Type", "application/json");
                        requestBuilder.content(bodyJson.toString().getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "cmd rest status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            JSONObject jsonResult = new JSONObject(result);
                            String statusParam = jsonResult.getString("status");
                            if (statusParam.equalsIgnoreCase("OK")) {
                                EMLog.d(KefuHttpClient.TAG, "rest status_code :ok");
                                if (callBack != null) {
                                    callBack.onSuccess();
                                    return;
                                }
                            } else if (statusParam.equalsIgnoreCase("FAIL")) {
                                if (result.contains("duplicated message") || result.contains("im_routeway_partner_002")) {
                                    EMLog.d(KefuHttpClient.TAG, "rest status_code: duplicated message");
                                    if (callBack != null) {
                                        callBack.onSuccess();
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_001")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "Can not find channel, please check appkey & im service num.");
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_003")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "Server Got an exception");
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_004")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "Got bodies exception");
                                    }
                                    return;
                                }
                                if (result.contains("im_routeway_partner_005")) {
                                    if (callBack != null) {
                                        callBack.onError(1, "msg_id_for_ack is blank.");
                                    }
                                    return;
                                }
                                if (callBack != null) {
                                    callBack.onError(1, "result:" + result);
                                }
                                return;
                            }
                            EMLog.d(KefuHttpClient.TAG, "rest status_code: FAIL :" + status_code);
                            if (callBack != null) {
                                callBack.onError(1, "statusCode:" + status_code);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callBack == null) break block21;
                        callBack.onError(1, "error:" + e.getMessage());
                    }
                }
            }
        });
    }

    public static void asyncGetVecChatMessage(final String rtcSessionId, final String visitorId, final ValueCallBack<String> callBack) {
        receiveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block9: {
                    try {
                        String tenantId = ChatClient.getInstance().tenantId();
                        if (TextUtils.isEmpty((CharSequence)tenantId)) {
                            if (callBack != null) {
                                callBack.onError(500, "tenantId is not set");
                            }
                            return;
                        }
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/kefurtc/tenant/%2$s/session/%3$s/visitor/%4$s/messages", urlRoot, tenantId, rtcSessionId, visitorId);
                        EMLog.e(KefuHttpClient.TAG, "asyncGetVecChatMessage url = " + remoteUrl);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.header("Content-Type", "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d(KefuHttpClient.TAG, "asyncGetVecChatMessage status_code:" + status_code);
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        } else if (callBack != null) {
                            callBack.onError(-1, "asyncGetVecChatMessage from server fail");
                        }
                    }
                    catch (Exception e) {
                        if (callBack == null) break block9;
                        callBack.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }
}

