/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.CryptoUtils;
import com.hyphenate.util.EMLog;

public class PreferenceUtil {
    private static PreferenceUtil instance = new PreferenceUtil();
    private static final String TAG = "PreferenceUtil";
    private final String SHARED_FILE = "kefuinfo";
    private final String SHARED_KEY_UNAME = "username";
    private final String SHARED_KEY_UPASS = "password";
    private final String SHARED_KEY_ENCRYPTPASS = "encrypt_pass";
    private final String SHARED_KEY_TOKEN = "token";
    private final String SHARED_KEY_LOGIN_WITH_TOKEN = "login_with_token";
    private final String SHARED_KEY_SERVER_JSON = "server_json";
    private final String SHARED_KEY_UNIQUE_ID = "unique_id";
    private final String SHARED_KEY_TRIGGER_EVENT_TIME = "trigger_event_time";
    private final String SHARED_KEY_SDK_REPORT = "sdk_report_%s";
    private final String SHARED_KEY_SDK_REPORT_UUID = "sdk_report_uuid";
    private Context mContext;
    private SharedPreferences sp;
    private SharedPreferences.Editor editor;
    private CryptoUtils cryptoUtils = new CryptoUtils();

    private PreferenceUtil() {
        this.cryptoUtils.initAES();
    }

    public static PreferenceUtil getInstance() {
        return instance;
    }

    public void init(Context context) {
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
        this.sp = this.mContext.getSharedPreferences("kefuinfo", 0);
        this.editor = this.sp.edit();
    }

    public void setUsername(String uname) {
        this.editor.putString("username", uname.toLowerCase());
        this.editor.commit();
    }

    void setUsernameAndPassword(String username, String password) {
        this.editor.putString("username", username.toLowerCase());
        String tempPwd = password;
        try {
            tempPwd = this.cryptoUtils.encryptBase64String(tempPwd);
        }
        catch (Exception ignored) {
            EMLog.e(TAG, "setUsernameAndPassword error = " + ignored.getMessage());
        }
        this.editor.putString("encrypt_pass", tempPwd);
        this.editor.commit();
    }

    void setToken(String token) {
        this.editor.putString("token", token);
        this.editor.commit();
    }

    void saveLoginWithToken(boolean isToken) {
        this.editor.putBoolean("login_with_token", isToken);
        this.editor.commit();
    }

    String getPassword() {
        String tempPwd = this.sp.getString("encrypt_pass", null);
        if (tempPwd == null) {
            tempPwd = this.sp.getString("password", null);
        }
        if (tempPwd == null) {
            return null;
        }
        try {
            tempPwd = this.cryptoUtils.decryptBase64String(tempPwd);
        }
        catch (Exception ignored) {
            EMLog.e(TAG, "PreferenceUtil getPassword = " + ignored.getMessage());
        }
        return tempPwd;
    }

    synchronized void setSdkReport(String userName, boolean isSuc) {
        if (TextUtils.isEmpty((CharSequence)userName)) {
            return;
        }
        ChatClient.getInstance().setSdkReport(isSuc);
    }

    synchronized boolean getSdkReport(String userName) {
        if (TextUtils.isEmpty((CharSequence)userName)) {
            return false;
        }
        return ChatClient.getInstance().getSdkReport();
    }

    synchronized void setSdkReportUUid(String uuid) {
        this.editor.putString("sdk_report_uuid", uuid);
        this.editor.commit();
    }

    String getSdkReportUUid() {
        return this.sp.getString("sdk_report_uuid", "");
    }

    public String getUsername() {
        return this.sp.getString("username", null);
    }

    String getToken() {
        return this.sp.getString("token", null);
    }

    String getServerJson() {
        return this.sp.getString("server_json", null);
    }

    boolean loginWithToken() {
        return this.sp.getBoolean("login_with_token", false);
    }

    void setServerJson(String serverJson) {
        this.editor.putString("server_json", serverJson);
        this.editor.commit();
    }

    void setUniqueId(String uuid) {
        this.editor.putString("unique_id", uuid);
        this.editor.commit();
    }

    String getUniqueId() {
        return this.sp.getString("unique_id", null);
    }

    void setTriggerEventTime(long triggerEventTime) {
        try {
            this.editor.putLong("trigger_event_time", triggerEventTime);
            this.editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    long getTriggerEventTime() {
        return this.sp.getLong("trigger_event_time", -1L);
    }

    void removeAll() {
        try {
            ChatClient.getInstance().setSdkReport(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.editor.remove("trigger_event_time");
        this.editor.remove("username");
        this.editor.remove("password");
        this.editor.remove("encrypt_pass");
        this.editor.remove("server_json");
        this.editor.remove("token");
        this.editor.commit();
    }

    public void putString(String key, String value) {
        this.editor.putString(key, value);
        this.editor.commit();
    }

    public String getString(String key) {
        return this.sp.getString(key, "");
    }
}

