/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.MarketingHttpClient;
import com.hyphenate.chat.PreferenceUtil;
import com.hyphenate.helpdesk.util.Log;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

class SdkReport {
    private static final String TAG = "SdkReport";
    private static SdkReport sSdkReport;
    private final ExecutorService mSendThreadPool = Executors.newFixedThreadPool(2);
    private static final int sTime = 2000;
    private volatile String mUserName;

    private SdkReport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SdkReport getSdkReport() {
        if (sSdkReport != null) return sSdkReport;
        Class<SdkReport> clazz = SdkReport.class;
        synchronized (SdkReport.class) {
            if (sSdkReport != null) return sSdkReport;
            sSdkReport = new SdkReport();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sSdkReport;
        }
    }

    void loginReport() throws Exception {
        String content;
        this.mUserName = PreferenceUtil.getInstance().getUsername();
        boolean sdkReport = PreferenceUtil.getInstance().getSdkReport(this.mUserName);
        if (sdkReport) {
            return;
        }
        String tenantId = ChatClient.getInstance().tenantId();
        boolean code = MarketingHttpClient.reportSdk(tenantId, content = this.getContent());
        if (code) {
            PreferenceUtil.getInstance().setSdkReport(this.mUserName, code);
            return;
        }
        if (this.mSendThreadPool != null) {
            this.mSendThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!ChatClient.getInstance().isLoggedInBefore()) {
                            Log.e(SdkReport.TAG, "loginReport isLoggedInBefore = false");
                            return;
                        }
                        String mame = SdkReport.this.mUserName;
                        boolean sdkReport = PreferenceUtil.getInstance().getSdkReport(SdkReport.this.mUserName);
                        if (sdkReport) {
                            return;
                        }
                        SystemClock.sleep((long)2000L);
                        if (!ChatClient.getInstance().isLoggedInBefore()) {
                            Log.e(SdkReport.TAG, "loginReport isLoggedInBefore = false");
                            return;
                        }
                        String tenantId = ChatClient.getInstance().tenantId();
                        String content = SdkReport.this.getContent();
                        boolean code = MarketingHttpClient.reportSdk(tenantId, content);
                        Log.e(SdkReport.TAG, "loginReport setSdkReport 2 mame = " + mame + "\uff0cisOK = " + code);
                        if (code) {
                            PreferenceUtil.getInstance().setSdkReport(mame, code);
                            return;
                        }
                        SystemClock.sleep((long)2000L);
                        if (!ChatClient.getInstance().isLoggedInBefore()) {
                            Log.e(SdkReport.TAG, "loginReport isLoggedInBefore = false");
                            return;
                        }
                        code = MarketingHttpClient.reportSdk(tenantId, content);
                        Log.e(SdkReport.TAG, "loginReport setSdkReport 3 mame = " + mame + "\uff0cisOK = " + code);
                        if (code) {
                            PreferenceUtil.getInstance().setSdkReport(mame, code);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Log.e(SdkReport.TAG, "loginReport setSdkReport error = " + e.getMessage());
                    }
                }
            });
        }
    }

    public String getContent() throws Exception {
        String username = PreferenceUtil.getInstance().getUsername();
        if (TextUtils.isEmpty((CharSequence)username)) {
            Log.e(TAG, "SdkReport getContent username = null.");
            return "";
        }
        JSONObject object = new JSONObject();
        object.put("sys_version", Build.VERSION.SDK_INT);
        if (ChatClient.getInstance().getContext() != null) {
            object.put("packageName", (Object)ChatClient.getInstance().getContext().getPackageName());
        }
        object.put("platform_id", 10);
        if (ChatClient.getInstance() != null) {
            object.put("sdk_versions", (Object)ChatClient.getInstance().sdkVersion());
        }
        object.put("timestamp", System.currentTimeMillis());
        if (PreferenceUtil.getInstance() != null) {
            String uniqueId = PreferenceUtil.getInstance().getSdkReportUUid();
            if (TextUtils.isEmpty((CharSequence)uniqueId) && TextUtils.isEmpty((CharSequence)(uniqueId = PreferenceUtil.getInstance().getUniqueId()))) {
                uniqueId = UUID.randomUUID().toString();
                PreferenceUtil.getInstance().setSdkReportUUid(uniqueId);
            }
            object.put("platform_uuid", (Object)uniqueId);
        }
        object.put("equipment", (Object)Build.MODEL);
        object.put("visitorUserName", (Object)username);
        object.put("appKey", (Object)ChatClient.getInstance().appKey());
        Log.e(TAG, "content = " + object);
        return object.toString();
    }
}

