/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.AgoraMessage;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.CountDownUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.chat.EMNormalFileMessageBody;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.chat.FilePathMessage;
import com.hyphenate.chat.KefuDBManager;
import com.hyphenate.chat.KefuHttpClient;
import com.hyphenate.chat.Message;
import com.hyphenate.chat.VecConversation;
import com.hyphenate.chat.VecDatabaseManager;
import com.hyphenate.helpdesk.callback.Callback;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.httpclient.HttpClient;
import com.hyphenate.helpdesk.httpclient.HttpRequestBuilder;
import com.hyphenate.helpdesk.httpclient.HttpResponse;
import com.hyphenate.helpdesk.httpclient.ProgressListener;
import com.hyphenate.helpdesk.util.HtmlUtil;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.ImageUtils;
import com.hyphenate.util.PathUtil;
import com.hyphenate.util.UriUtils;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VecChatManager {
    private static final String TAG = "VecChatManager";
    private final String SEND_EXT_MSG_ID_FOR_ACK = "msg_id_for_ack";
    private final List<MessageListener> messageListeners = Collections.synchronizedList(new ArrayList());
    private static volatile VecChatManager sVecChatManager;
    private final ExecutorService downloadThreadPool = Executors.newCachedThreadPool();
    String mImServiceNum;
    String mRtcSessionId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VecChatManager getInstance() {
        if (sVecChatManager != null) return sVecChatManager;
        Class<VecChatManager> clazz = VecChatManager.class;
        synchronized (VecChatManager.class) {
            if (sVecChatManager != null) return sVecChatManager;
            sVecChatManager = new VecChatManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sVecChatManager;
        }
    }

    public void bindVecChat(String imServiceNum, String rtcSessionId) {
        this.mImServiceNum = imServiceNum;
        this.mRtcSessionId = rtcSessionId;
        this.getVecConversation().mIsOpen = true;
        EMLog.e(TAG, "bindVecChat rtcSessionId = " + rtcSessionId + ", imServiceNum = " + imServiceNum);
    }

    public String getRtcSessionId() {
        return this.mRtcSessionId;
    }

    public void unbindVecChat() {
        EMLog.e(TAG, "unbindVecChat mImServiceNum = null");
        this.getVecConversation().clear();
        this.mImServiceNum = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void resendMessage(String rtcSessionId, String visitorId, Message message, EMCallBack callback) {
        message.setStatus(Message.Status.INPROGRESS);
        message.setMessageTime(System.currentTimeMillis() / 1000L);
        message.setVecUserName(AgoraMessage.newAgoraMessage().getNickname());
        String originPath = null;
        if (message.getType() == Message.Type.IMAGE) {
            String thumbPath;
            String scaledImagePath;
            EMImageMessageBody body = (EMImageMessageBody)message.body();
            if (body == null) {
                message.setStatus(Message.Status.FAIL);
                if (callback == null) return;
                callback.onError(1, "Message body cannot be null");
                return;
            }
            Uri fileUri = body.getLocalUri();
            if (!UriUtils.isFileExistByUri(EMClient.getInstance().getContext(), fileUri)) {
                message.setStatus(Message.Status.FAIL);
                if (callback == null) return;
                callback.onError(401, "File not exists or can not be read");
                return;
            }
            String localUri = fileUri.toString();
            if (!body.isSendOriginalImage() && !(scaledImagePath = ImageUtils.getScaledImageByUri(EMClient.getInstance().getContext(), localUri)).equals(localUri)) {
                originPath = localUri;
                long originalSize = ImageUtils.getFileLength(EMClient.getInstance().getContext(), localUri);
                long scaledSize = ImageUtils.getFileLength(EMClient.getInstance().getContext(), scaledImagePath);
                if (originalSize == 0L) {
                    EMLog.d(TAG, "original image size:" + originalSize);
                    message.setStatus(Message.Status.FAIL);
                    if (callback == null) return;
                    callback.onError(401, "original image size is 0");
                    return;
                }
                localUri = scaledImagePath;
                body.setLocalUrl(UriUtils.getLocalUriFromString(localUri));
            }
            if (!TextUtils.isEmpty((CharSequence)(thumbPath = UriUtils.getFilePath(EMClient.getInstance().getContext(), body.getThumbnailUrl())))) {
                BitmapFactory.Options options = ImageUtils.getBitmapOptions(thumbPath);
                int width = options.outWidth;
                int height = options.outHeight;
                body.setThumbnailSize(width, height);
            }
            body.setFileName(ImageUtils.getFilename(EMClient.getInstance().getContext(), localUri));
        }
        if (message.getType() != Message.Type.CMD) {
            Class<VecChatManager> clazz = VecChatManager.class;
            // MONITORENTER : com.hyphenate.chat.VecChatManager.class
            VecDatabaseManager.getInstance().updateMessageStateAndTime(rtcSessionId, message);
            // MONITOREXIT : clazz
        }
        EMLog.e(TAG, "send vecChat message isLoggedInBefore() = " + ChatClient.getInstance().isLoggedInBefore());
        this.notifyMessageSent();
        this.sendRESTMessage(true, rtcSessionId, visitorId, message, callback);
        CountDownUtils.getInstance().sendBroadcast();
    }

    public void resendMessage(String rtcSessionId, String visitorId, Message message) {
        try {
            this.resendMessage(rtcSessionId, visitorId, message, null);
            EMLog.e(TAG, "vec\u804a\u5929 \u91cd\u53d1\u6d88\u606f resendMessage messageId = " + message.messageId());
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "resendMessage error = " + e.getMessage());
        }
    }

    public void sendMessage(String visitorId, Message message) {
        String rtcSessionId = ChatClient.getInstance().vecChatManager().mRtcSessionId;
        if (TextUtils.isEmpty((CharSequence)rtcSessionId)) {
            throw new RuntimeException("\u8bf7\u5148\u8c03\u7528ChatClient.getInstance().vecChatManager().bindVecChat()\u7ed1\u5b9a\u804a\u5929\u9875\u9762\uff01");
        }
        try {
            this.sendMessage(rtcSessionId, visitorId, message, true, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "sendMessage error = " + e.getMessage());
        }
    }

    public void sendMessage(String rtcSessionId, String visitorId, Message message) {
        if (TextUtils.isEmpty((CharSequence)visitorId)) {
            throw new RuntimeException("vec sendMessage \u53c2\u6570 visitorId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            this.sendMessage(rtcSessionId, visitorId, message, true, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "sendMessage error = " + e.getMessage());
        }
    }

    public void sendMessage(String rtcSessionId, String visitorId, Message message, Callback callback) {
        if (TextUtils.isEmpty((CharSequence)visitorId)) {
            throw new RuntimeException("vec sendMessage \u53c2\u6570 visitorId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            this.sendMessage(rtcSessionId, visitorId, message, true, callback);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "sendMessage error = " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void sendMessage(String rtcSessionId, String visitorId, Message message, boolean isRecord, Callback callback) {
        EMTextMessageBody txtBody;
        message.setMessageTime(System.currentTimeMillis() / 1000L);
        message.setVecUserName(AgoraMessage.newAgoraMessage().getNickname());
        AgoraMessage.newAgoraMessage().addVisitorInfoToMessage(message);
        if (message.messageId() == null) {
            message.setMsgId(UUID.randomUUID().toString());
        }
        JSONObject jsonWeichat = null;
        try {
            jsonWeichat = message.getJSONObjectAttribute("weichat");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jsonWeichat == null) {
            jsonWeichat = new JSONObject();
        }
        try {
            if (ChatClient.getInstance().hasSecondChannel) {
                jsonWeichat.put("msg_id_for_ack", (Object)message.messageId());
            }
            jsonWeichat.put("msgId", (Object)message.messageId());
        }
        catch (JSONException ignored) {
            ignored.printStackTrace();
        }
        message.setAttribute("weichat", jsonWeichat);
        EMMessageBody messageBody = message.body();
        if (messageBody == null) {
            EMLog.e(TAG, "messagebody is nulll");
            if (callback != null) {
                callback.onError(1, "body is null");
            }
            if (message.messageStatusCallBack == null) return;
            message.messageStatusCallBack.onError(1, "body is null");
            return;
        }
        String currentUser = ChatClient.getInstance().currentUserName();
        if (TextUtils.isEmpty((CharSequence)currentUser)) {
            EMLog.e(TAG, "sendMessage vec currentUserName is empty");
            if (callback != null) {
                callback.onError(1, "please login before");
            }
            if (message.messageStatusCallBack == null) return;
            message.messageStatusCallBack.onError(1, "please login before");
            return;
        }
        message.setFrom(currentUser);
        if (message.getType() == Message.Type.TXT && (txtBody = (EMTextMessageBody)messageBody).getMessage() != null && txtBody.getMessage().length() > 1500) {
            if (callback != null) {
                callback.onError(502, "text message length could not more than 1500");
            }
            if (message.messageStatusCallBack == null) return;
            message.messageStatusCallBack.onError(502, "text message length could not more than 1500");
            return;
        }
        String originPath = null;
        if (message.getType() == Message.Type.IMAGE) {
            String thumbPath;
            String scaledImagePath;
            EMImageMessageBody body = (EMImageMessageBody)message.body();
            if (body == null) {
                message.setStatus(Message.Status.FAIL);
                if (callback == null) return;
                callback.onError(1, "Message body cannot be null");
                return;
            }
            Uri fileUri = body.getLocalUri();
            if (!UriUtils.isFileExistByUri(EMClient.getInstance().getContext(), fileUri)) {
                message.setStatus(Message.Status.FAIL);
                if (callback == null) return;
                callback.onError(401, "File not exists or can not be read");
                return;
            }
            String localUri = fileUri.toString();
            if (!body.isSendOriginalImage() && !(scaledImagePath = ImageUtils.getScaledImageByUri(EMClient.getInstance().getContext(), localUri)).equals(localUri)) {
                originPath = localUri;
                long originalSize = ImageUtils.getFileLength(EMClient.getInstance().getContext(), localUri);
                if (originalSize == 0L) {
                    EMLog.d(TAG, "original image size:" + originalSize);
                    message.setStatus(Message.Status.FAIL);
                    if (callback == null) return;
                    callback.onError(401, "original image size is 0");
                    return;
                }
                localUri = scaledImagePath;
                body.setLocalUrl(UriUtils.getLocalUriFromString(localUri));
            }
            if (!TextUtils.isEmpty((CharSequence)(thumbPath = UriUtils.getFilePath(EMClient.getInstance().getContext(), body.getThumbnailUrl())))) {
                BitmapFactory.Options options = ImageUtils.getBitmapOptions(thumbPath);
                int width = options.outWidth;
                int height = options.outHeight;
                body.setThumbnailSize(width, height);
            }
            body.setFileName(ImageUtils.getFilename(EMClient.getInstance().getContext(), localUri));
        }
        message.setStatus(Message.Status.INPROGRESS);
        if (isRecord && message.getType() != Message.Type.CMD) {
            Class<VecChatManager> clazz = VecChatManager.class;
            // MONITORENTER : com.hyphenate.chat.VecChatManager.class
            VecDatabaseManager.getInstance().saveMessage(rtcSessionId, message);
            VecChatManager.getInstance().getVecConversation().addMessage(message);
            // MONITOREXIT : clazz
        }
        EMLog.e(TAG, "send vecChat message isLoggedInBefore() = " + ChatClient.getInstance().isLoggedInBefore());
        this.notifyMessageSent();
        this.sendRESTMessage(false, rtcSessionId, visitorId, message, callback);
        CountDownUtils.getInstance().sendBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMessageSent() {
        List<MessageListener> list = this.messageListeners;
        synchronized (list) {
            for (MessageListener listener : this.messageListeners) {
                listener.onMessageSent();
            }
        }
    }

    private void sendRESTMessage(boolean isReSend, final String rtcSessionId, String visitorId, final Message mesage, final EMCallBack callback) {
        EMLog.e(TAG, "vec sendRESTMessage type = " + (Object)((Object)mesage.getType()));
        KefuHttpClient.sendVecMessageByKefuRest(isReSend, rtcSessionId, visitorId, mesage, new EMCallBack(){

            @Override
            public void onSuccess() {
                EMLog.e(VecChatManager.TAG, "vec sendRESTMessage onSuccess");
                mesage.setStatus(Message.Status.SUCCESS);
                VecChatManager.this.updateMessageState(rtcSessionId, mesage);
                if (mesage.messageStatusCallBack != null) {
                    mesage.messageStatusCallBack.onSuccess();
                }
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                EMLog.e(VecChatManager.TAG, "vec send kefu message:" + errorMsg);
                mesage.setStatus(Message.Status.FAIL);
                VecChatManager.this.updateMessageState(rtcSessionId, mesage);
                if (mesage.messageStatusCallBack != null) {
                    mesage.messageStatusCallBack.onError(error, errorMsg);
                }
                if (callback != null) {
                    callback.onError(error, errorMsg);
                }
            }

            @Override
            public void onProgress(int i, String s) {
            }
        });
    }

    private void updateMessageState(String rtcSessionId, Message message) {
        VecDatabaseManager.getInstance().updateMessageState(rtcSessionId, message);
    }

    public void addMessageListener(MessageListener messageListener) {
        if (messageListener == null) {
            return;
        }
        if (!this.messageListeners.contains(messageListener)) {
            this.messageListeners.add(messageListener);
        }
    }

    public void removeMessageListener(MessageListener messageListener) {
        if (messageListener == null) {
            return;
        }
        this.messageListeners.remove(messageListener);
    }

    boolean isVecChatMessage(List<EMMessage> messages) {
        for (EMMessage msg : messages) {
            EMCmdMessageBody cmdBody;
            String action;
            if (!(msg.getBody() instanceof EMCmdMessageBody) || !"vecNewChatMsg".equals(action = (cmdBody = (EMCmdMessageBody)msg.getBody()).action())) continue;
            return true;
        }
        return false;
    }

    List<EMMessage> getVecChatMessage(List<EMMessage> messages) {
        ArrayList<EMMessage> vecMessages = new ArrayList<EMMessage>();
        Iterator<EMMessage> iterator = messages.iterator();
        while (iterator.hasNext()) {
            EMMessage msg = iterator.next();
            EMCmdMessageBody cmdBody = (EMCmdMessageBody)msg.body;
            String action = cmdBody.action();
            if (!"vecNewChatMsg".equals(action)) continue;
            vecMessages.add(msg);
            iterator.remove();
        }
        return vecMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onVecChatCmdMessageNotify(List<EMMessage> messages) {
        List<MessageListener> list = this.messageListeners;
        synchronized (list) {
            for (MessageListener listener : this.messageListeners) {
                listener.onNewChatMessageNotify();
            }
        }
    }

    public void asyncGetVecChatMessage(String rtcSessionId, String visitorId, final ValueCallBack<String> callBack) {
        KefuHttpClient.asyncGetVecChatMessage(rtcSessionId, visitorId, new ValueCallBack<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(String value) {
                EMLog.e(VecChatManager.TAG, "asyncGetVecChatMessage onSuccess = " + value);
                Class<VecChatManager> clazz = VecChatManager.class;
                synchronized (VecChatManager.class) {
                    VecChatManager.this.parseMessage(value);
                    if (callBack != null) {
                        callBack.onSuccess(value);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                EMLog.e(VecChatManager.TAG, "asyncGetVecChatMessage errorMsg = " + errorMsg);
                if (callBack != null) {
                    callBack.onError(-1, errorMsg);
                }
            }
        });
    }

    public VecConversation getVecConversation() {
        return VecConversation.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void parseMessage(String value) {
        try {
            JSONObject jsonValue = new JSONObject(HtmlUtil.htmlspecialchars_decode_END_NOQUOTES(value));
            EMLog.e(TAG, "parseMessage jsonValue = " + jsonValue);
            EMLog.e(TAG, "parseMessage \u5f53\u524d\u7528\u6237\u540d = " + ChatClient.getInstance().currentUserName());
            String status = jsonValue.optString("status", "");
            if (!status.equalsIgnoreCase("OK")) {
                return;
            }
            JSONArray jsonEntities = jsonValue.getJSONArray("entities");
            if (jsonEntities.length() == 0) {
                return;
            }
            ArrayList<Message> msgList = new ArrayList<Message>();
            int k = 0;
            while (true) {
                String fromUserName;
                if (k >= jsonEntities.length()) {
                    if (msgList.size() <= 0) return;
                    Collections.reverse(msgList);
                    this.publishNewMessage(msgList);
                    return;
                }
                JSONObject jsonEntityOne = jsonEntities.getJSONObject(k);
                JSONArray jsonMsgBodys = jsonEntityOne.getJSONArray("bodies");
                JSONObject jsonExt = jsonEntityOne.getJSONObject("ext");
                JSONObject weiChat = jsonExt.getJSONObject("weichat");
                JSONObject jsonMsgBody = jsonMsgBodys.getJSONObject(0);
                String type = jsonMsgBody.getString("type");
                String from = jsonEntityOne.optString("from");
                JSONObject service_session = weiChat.optJSONObject("service_session");
                String serviceSessionId = null;
                if (service_session != null) {
                    serviceSessionId = service_session.optString("serviceSessionId");
                }
                fromUserName = TextUtils.isEmpty((CharSequence)(fromUserName = weiChat.getString("agentUsername"))) ? "" : fromUserName;
                fromUserName = fromUserName.equals("null") ? "" : fromUserName;
                long timestamp = jsonEntityOne.optLong("timestamp");
                timestamp /= 1000L;
                String extMsgId = weiChat.getString("msgId");
                if (!from.equals(ChatClient.getInstance().currentUserName())) {
                    Object thumnailLocalUri;
                    Message message;
                    String remoteUrl;
                    Class<VecChatManager> clazz = VecChatManager.class;
                    // MONITORENTER : com.hyphenate.chat.VecChatManager.class
                    boolean isExist = VecDatabaseManager.getInstance().isMessageExistedByExtMsgId(extMsgId, serviceSessionId);
                    if (isExist) {
                        EMLog.e(TAG, "asyncGetVecChatMessage isExist = true \u8df3\u8fc7 json = " + jsonEntityOne);
                        // MONITOREXIT : clazz
                    } else if (type.equalsIgnoreCase("txt")) {
                        String txtMsg = jsonMsgBody.getString("msg");
                        Message message2 = new Message(Message.Type.TXT);
                        if (from.equals(ChatClient.getInstance().currentUserName())) {
                            message2.setDirection(Message.Direct.SEND);
                            message2.setKefuReceived(false);
                        } else {
                            message2.setDirection(Message.Direct.RECEIVE);
                            message2.setKefuReceived(true);
                        }
                        message2.setBody(new EMTextMessageBody(txtMsg));
                        message2.attributes = VecChatManager.json2Map(jsonExt);
                        message2.setMsgId(extMsgId);
                        message2.setStatus(Message.Status.SUCCESS);
                        message2.setFrom(from);
                        message2.setMessageTime(timestamp);
                        message2.setVecUserName(fromUserName);
                        VecChatManager.checkOfficialAccount(message2);
                        if (!TextUtils.isEmpty((CharSequence)serviceSessionId)) {
                            Class<VecChatManager> clazz2 = VecChatManager.class;
                            // MONITORENTER : com.hyphenate.chat.VecChatManager.class
                            VecDatabaseManager.getInstance().saveMessage(serviceSessionId, message2);
                            // MONITOREXIT : clazz2
                        }
                        msgList.add(message2);
                    } else if (type.equalsIgnoreCase("img")) {
                        remoteUrl = jsonMsgBody.getString("url");
                        if (!remoteUrl.startsWith("http")) {
                            remoteUrl = ChatClient.getInstance().kefuRestServer() + jsonMsgBody.getString("url");
                        }
                        String mediaId = jsonMsgBody.has("mediaId") ? jsonMsgBody.getString("mediaId") : System.currentTimeMillis() + "";
                        String fileName = jsonMsgBody.has("filename") ? jsonMsgBody.getString("filename") : mediaId + ".png";
                        String localPathName = System.currentTimeMillis() + "_" + from + "_" + fileName;
                        String localPath = new File(PathUtil.getInstance().getImagePath(), localPathName).getPath();
                        String tempLocalPathName = "thumb_" + localPathName;
                        String thumbLocalPath = new File(PathUtil.getInstance().getImagePath(), tempLocalPathName).getPath();
                        message = new Message(Message.Type.IMAGE);
                        if (from.equals(ChatClient.getInstance().currentUserName())) {
                            message.setDirection(Message.Direct.SEND);
                            message.setKefuReceived(false);
                        } else {
                            message.setDirection(Message.Direct.RECEIVE);
                            message.setKefuReceived(true);
                        }
                        message.setFrom(from);
                        Uri localUri = UriUtils.getLocalUriFromString(localPath);
                        if (localUri == null) {
                            localUri = Uri.parse((String)"");
                        }
                        thumnailLocalUri = UriUtils.getLocalUriFromString(thumbLocalPath);
                        EMImageMessageBody body = new EMImageMessageBody(localUri, (Uri)thumnailLocalUri);
                        body.setRemoteUrl(remoteUrl);
                        body.setFileName(localPathName);
                        if (jsonMsgBody.has("thumb")) {
                            String thumbnailUrl = jsonMsgBody.getString("thumb");
                            thumbnailUrl = TextUtils.isEmpty((CharSequence)thumbnailUrl) ? remoteUrl : thumbnailUrl;
                            body.setThumbnailUrl(thumbnailUrl);
                        }
                        if (jsonMsgBody.has("secret")) {
                            body.setSecret(jsonMsgBody.getString("secret"));
                        }
                        if (jsonMsgBody.has("thumb_secret")) {
                            body.setThumbnailSecret(jsonMsgBody.getString("thumb_secret"));
                        }
                        if (jsonMsgBody.has("size")) {
                            JSONObject sizeJson = jsonMsgBody.getJSONObject("size");
                            int width = 0;
                            int height = 0;
                            if (sizeJson.has("width")) {
                                if (!sizeJson.isNull("width")) {
                                    width = sizeJson.getInt("width");
                                }
                                if (!sizeJson.isNull("height")) {
                                    height = sizeJson.getInt("height");
                                }
                            }
                            body.setSize(width, height);
                        }
                        message.setBody(body);
                        message.attributes = VecChatManager.json2Map(jsonExt);
                        message.setMsgId(extMsgId);
                        message.setStatus(Message.Status.SUCCESS);
                        message.setMessageTime(timestamp);
                        message.setVecUserName(fromUserName);
                        VecChatManager.checkOfficialAccount(message);
                        ChatClient.getInstance().vecChatManager().downloadAttachments(message, true);
                        if (!TextUtils.isEmpty((CharSequence)serviceSessionId)) {
                            Class<VecChatManager> clazz3 = VecChatManager.class;
                            // MONITORENTER : com.hyphenate.chat.VecChatManager.class
                            VecDatabaseManager.getInstance().saveMessage(serviceSessionId, message);
                            // MONITOREXIT : clazz3
                        }
                        msgList.add(message);
                    } else if (type.equalsIgnoreCase("file")) {
                        String fileName;
                        remoteUrl = jsonMsgBody.optString("url");
                        if (TextUtils.isEmpty((CharSequence)remoteUrl) || remoteUrl.equals("null")) {
                            remoteUrl = jsonMsgBody.optString("localurl");
                        }
                        if (!remoteUrl.startsWith("http")) {
                            remoteUrl = ChatClient.getInstance().kefuRestServer() + remoteUrl;
                        }
                        if (!TextUtils.isEmpty((CharSequence)(fileName = jsonMsgBody.optString("filename")))) {
                            fileName = URLDecoder.decode(fileName);
                        }
                        long fileLength = 0L;
                        if (jsonMsgBody.has("file_length")) {
                            fileLength = jsonMsgBody.getLong("file_length");
                        }
                        String localPathName = System.currentTimeMillis() + "_" + from + "_" + fileName;
                        String localPath = new File(PathUtil.getInstance().getFilePath(), localPathName).getPath();
                        Uri localUri = UriUtils.getLocalUriFromString(localPath);
                        message = new Message(Message.Type.FILE);
                        if (from.equals(ChatClient.getInstance().currentUserName())) {
                            message.setDirection(Message.Direct.SEND);
                            message.setKefuReceived(false);
                        } else {
                            message.setDirection(Message.Direct.RECEIVE);
                            message.setKefuReceived(true);
                        }
                        message.setFrom(from);
                        EMNormalFileMessageBody body = new EMNormalFileMessageBody(remoteUrl, remoteUrl);
                        if (localUri == null) {
                            body.setLocalUrl(localPath);
                        } else {
                            body.setLocalUrl(localUri);
                        }
                        body.setFileLength(fileLength);
                        body.setFileName(fileName);
                        if (jsonMsgBody.has("secret")) {
                            body.setSecret(jsonMsgBody.getString("secret"));
                        }
                        message.setBody(body);
                        message.attributes = VecChatManager.json2Map(jsonExt);
                        message.setMsgId(extMsgId);
                        message.setStatus(Message.Status.SUCCESS);
                        message.setMessageTime(timestamp);
                        message.setVecUserName(fromUserName);
                        VecChatManager.checkOfficialAccount(message);
                        if (!TextUtils.isEmpty((CharSequence)serviceSessionId)) {
                            thumnailLocalUri = VecChatManager.class;
                            // MONITORENTER : com.hyphenate.chat.VecChatManager.class
                            VecDatabaseManager.getInstance().saveMessage(serviceSessionId, message);
                            // MONITOREXIT : thumnailLocalUri
                        }
                        msgList.add(message);
                    } else if (type.equalsIgnoreCase("video")) {
                        remoteUrl = jsonMsgBody.optString("url");
                        if (TextUtils.isEmpty((CharSequence)remoteUrl) || remoteUrl.equals("null")) {
                            remoteUrl = jsonMsgBody.optString("localurl");
                        }
                        if (!remoteUrl.startsWith("http")) {
                            remoteUrl = ChatClient.getInstance().kefuRestServer() + jsonMsgBody.getString("url");
                        }
                        String fileName = jsonMsgBody.getString("filename");
                        String localPathName = System.currentTimeMillis() + "_" + from + "_" + fileName;
                        String localPath = new File(PathUtil.getInstance().getImagePath(), localPathName).getPath();
                        String tempLocalPathName = "thumb_" + localPathName;
                        String thumbLocalPath = new File(PathUtil.getInstance().getImagePath(), tempLocalPathName).getPath();
                        Message message3 = new Message(Message.Type.VIDEO);
                        if (from.equals(ChatClient.getInstance().currentUserName())) {
                            message3.setDirection(Message.Direct.SEND);
                            message3.setKefuReceived(false);
                        } else {
                            message3.setDirection(Message.Direct.RECEIVE);
                            message3.setKefuReceived(true);
                        }
                        message3.setFrom(from);
                        Uri localUri = UriUtils.getLocalUriFromString(localPath);
                        if (localUri == null) {
                            localUri = Uri.parse((String)"");
                        }
                        int length = 0;
                        if (jsonMsgBody.has("length")) {
                            length = jsonMsgBody.getInt("length");
                        }
                        EMVideoMessageBody body = new EMVideoMessageBody(fileName, remoteUrl, thumbLocalPath, length);
                        body.setRemoteUrl(remoteUrl);
                        body.setFileName(fileName);
                        if (localUri == null) {
                            body.setLocalUrl(localPath);
                        } else {
                            body.setLocalUrl(localUri);
                        }
                        if (jsonMsgBody.has("thumb")) {
                            String thumbnailUrl = jsonMsgBody.getString("thumb");
                            if (!thumbnailUrl.startsWith("http")) {
                                thumbnailUrl = ChatClient.getInstance().kefuRestServer() + thumbnailUrl;
                            }
                            thumbnailUrl = TextUtils.isEmpty((CharSequence)thumbnailUrl) ? "" : thumbnailUrl;
                            body.setThumbnailUrl(thumbnailUrl);
                        } else {
                            body.setThumbnailUrl("");
                        }
                        if (jsonMsgBody.has("secret")) {
                            body.setSecret(jsonMsgBody.getString("secret"));
                        }
                        if (jsonMsgBody.has("thumb_secret")) {
                            body.setThumbnailSecret(jsonMsgBody.getString("thumb_secret"));
                        }
                        message3.setBody(body);
                        message3.attributes = VecChatManager.json2Map(jsonExt);
                        message3.setMsgId(extMsgId);
                        message3.setStatus(Message.Status.SUCCESS);
                        message3.setMessageTime(timestamp);
                        message3.setVecUserName(fromUserName);
                        VecChatManager.checkOfficialAccount(message3);
                        if (!TextUtils.isEmpty((CharSequence)serviceSessionId)) {
                            Class<VecChatManager> clazz4 = VecChatManager.class;
                            // MONITORENTER : com.hyphenate.chat.VecChatManager.class
                            VecDatabaseManager.getInstance().saveMessage(serviceSessionId, message3);
                            // MONITOREXIT : clazz4
                        }
                        msgList.add(message3);
                    } else {
                        EMLog.e(TAG, "vec jsonMsgBody-else:" + jsonMsgBody.toString());
                    }
                }
                ++k;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            EMLog.e(TAG, "jsonError:" + Log.getStackTraceString((Throwable)e));
            EMLog.e(TAG, "jsonError value:" + value);
        }
    }

    private static Hashtable<String, Object> json2Map(JSONObject jsonObj) {
        try {
            Iterator keyIter = jsonObj.keys();
            Hashtable<String, Object> valueMap = new Hashtable<String, Object>();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                Object value = jsonObj.get(key);
                valueMap.put(key, value);
            }
            return valueMap;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void checkOfficialAccount(Message message) {
        try {
            JSONObject weichatJson = message.getJSONObjectAttribute("weichat");
            if (weichatJson != null && weichatJson.has("official_account")) {
                JSONObject jsonOffAccount = weichatJson.getJSONObject("official_account");
                String offAccountId = jsonOffAccount.getString("official_account_id");
                String type = jsonOffAccount.getString("type");
                if (!TextUtils.isEmpty((CharSequence)offAccountId) && !type.equals("SYSTEM")) {
                    message.setFrom(message.from() + "#|" + offAccountId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishNewMessage(List<Message> messages) {
        List<MessageListener> list = this.messageListeners;
        synchronized (list) {
            for (MessageListener listener : this.messageListeners) {
                VecConversation.getInstance().addMessageToList(messages);
                listener.onMessage(messages);
            }
        }
    }

    void downloadAttachments(Message message, boolean isThumbnail) {
        if (isThumbnail) {
            this.downloadThumbnail(message);
        } else {
            this.downloadAttachment(message);
        }
    }

    public void downloadAttachment(final Message message) {
        EMMessageBody body = message.body();
        if (!(body instanceof EMFileMessageBody)) {
            EMLog.d(TAG, "vec download file msg body is not FileMessageBody");
            return;
        }
        EMFileMessageBody msgBody = (EMFileMessageBody)message.body();
        final String remoteUrl = msgBody.getRemoteUrl();
        String localPath = msgBody.getLocalUrl();
        if (TextUtils.isEmpty((CharSequence)remoteUrl) || TextUtils.isEmpty((CharSequence)localPath)) {
            EMLog.d(TAG, "vec download file remoteUrl or localPath is empty");
            return;
        }
        final File localFile = new File(localPath);
        final File tempLocalFile = new File(localFile.getParent(), "tmp_" + localFile.getName());
        this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.DOWNLOADING, false);
        this.downloadThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                    try {
                        requestBuilder.to(tempLocalFile, new ProgressListener(){

                            @Override
                            public void loadProgress(long progress) {
                                if (message.messageStatusCallBack != null && progress < 100L) {
                                    message.messageStatusCallBack.onProgress((int)progress, "progress");
                                }
                            }
                        });
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onError(403, "rfile download failed");
                            }
                            return;
                        }
                        int status = httpResponse.getStatusCode();
                        if (status / 100 == 2) {
                            tempLocalFile.renameTo(localFile);
                            VecChatManager.this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.SUCCESSED, false);
                            VecChatManager.this.updateMessageBody(message);
                            VecChatManager.this.saveFilePath(message);
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onSuccess();
                            }
                        } else {
                            VecChatManager.this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.FAILED, false);
                            VecChatManager.this.updateMessageBody(message);
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onError(403, "file download failed");
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        VecChatManager.this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.FAILED, false);
                        VecChatManager.this.updateMessageBody(message);
                        if (message.messageStatusCallBack == null) break block8;
                        message.messageStatusCallBack.onError(403, "file download failed");
                    }
                }
            }
        });
    }

    public boolean updateMessageBody(Message message) {
        return KefuDBManager.getInstance().updateVecMessageBody(message);
    }

    private void updateMessageBodyDownloadStatus(Message message, EMFileMessageBody.EMDownloadStatus status, boolean isThumbnail) {
        switch (message.getType()) {
            case FILE: 
            case VOICE: {
                EMFileMessageBody fileBody = (EMFileMessageBody)message.body();
                fileBody.setDownloadStatus(status);
                break;
            }
            case IMAGE: {
                EMImageMessageBody imgBody = (EMImageMessageBody)message.body();
                if (isThumbnail) {
                    imgBody.setThumbnailDownloadStatus(status);
                    break;
                }
                imgBody.setDownloadStatus(status);
                break;
            }
        }
    }

    public void downloadThumbnail(final Message message) {
        String localPath;
        String remoteUrl;
        EMFileMessageBody msgBody;
        if (message.body() instanceof EMImageMessageBody) {
            msgBody = (EMImageMessageBody)message.body();
            remoteUrl = msgBody.getRemoteUrl();
            localPath = ((EMImageMessageBody)msgBody).thumbnailLocalPath();
        } else if (message.body() instanceof EMVideoMessageBody) {
            msgBody = (EMVideoMessageBody)message.body();
            remoteUrl = ((EMVideoMessageBody)msgBody).getThumbnailUrl();
            localPath = ((EMVideoMessageBody)msgBody).getLocalThumb();
        } else {
            EMLog.d(TAG, "download file msg body is not ImageMessageBody or EMVideoMessageBody");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)remoteUrl) || TextUtils.isEmpty((CharSequence)localPath)) {
            EMLog.d(TAG, "download file remoteUrl or localPath is empty");
            return;
        }
        final File localFile = new File(localPath);
        final File tempLocalFile = new File(localFile.getParent(), "tmp_" + localFile.getName());
        this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.DOWNLOADING, true);
        this.downloadThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                    HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                    requestBuilder.param("thumbnail", "true");
                    try {
                        requestBuilder.to(tempLocalFile);
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onError(403, "rfile download failed");
                            }
                            return;
                        }
                        int status = httpResponse.getStatusCode();
                        if (status / 100 == 2) {
                            tempLocalFile.renameTo(localFile);
                            VecChatManager.this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.SUCCESSED, true);
                            VecChatManager.this.updateMessageBody(message);
                            VecChatManager.this.saveFilePath(message);
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onSuccess();
                            }
                        } else {
                            VecChatManager.this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.FAILED, true);
                            VecChatManager.this.updateMessageBody(message);
                            if (message.messageStatusCallBack != null) {
                                message.messageStatusCallBack.onError(403, "file download failed");
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        VecChatManager.this.updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.FAILED, true);
                        VecChatManager.this.updateMessageBody(message);
                        if (message.messageStatusCallBack == null) break block8;
                        message.messageStatusCallBack.onError(403, "file download failed");
                    }
                }
            }
        });
    }

    private void saveFilePath(Message message) {
        VecDatabaseManager.getInstance().saveVecPathMessage(this.mRtcSessionId, message);
    }

    public void deleteFilePath(final int numberDayBefore, final boolean allRtcSessionId) {
        if (this.downloadThreadPool != null) {
            this.downloadThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        long currentTime = System.currentTimeMillis();
                        int oneDay = 86400;
                        long theDateTime = (currentTime - (long)(oneDay * numberDayBefore)) / 1000L;
                        String rtcSessionId = allRtcSessionId ? "" : VecChatManager.this.mRtcSessionId;
                        List<FilePathMessage> list = VecDatabaseManager.getInstance().getVecPathMessage(rtcSessionId, theDateTime);
                        if (list.size() > 0) {
                            for (FilePathMessage message : list) {
                                boolean delete;
                                boolean delete2;
                                File localThumbUrlFile;
                                File file;
                                String localUrl;
                                if (message.getLocaltype() != 0) continue;
                                int type = message.getType();
                                if (type == 0) {
                                    String localThumbUrl;
                                    boolean delete3;
                                    localUrl = message.getLocalurl();
                                    file = new File(localUrl);
                                    if (file.exists() && (delete3 = file.delete())) {
                                        VecDatabaseManager.getInstance().deletePathMessage(rtcSessionId, message);
                                    }
                                    if (!(localThumbUrlFile = new File(localThumbUrl = message.getLocalthumburl())).exists() || !(delete2 = localThumbUrlFile.delete())) continue;
                                    VecDatabaseManager.getInstance().deletePathMessage(rtcSessionId, message);
                                    continue;
                                }
                                if (type == 1) {
                                    String localThumbUrl;
                                    boolean delete4;
                                    localUrl = message.getLocalurl();
                                    file = new File(localUrl);
                                    if (file.exists() && (delete4 = file.delete())) {
                                        VecDatabaseManager.getInstance().deletePathMessage(rtcSessionId, message);
                                    }
                                    if (!(localThumbUrlFile = new File(localThumbUrl = message.getLocalthumburl())).exists() || !(delete2 = file.delete())) continue;
                                    VecDatabaseManager.getInstance().deletePathMessage(rtcSessionId, message);
                                    continue;
                                }
                                if (type != 2 || !(file = new File(localUrl = message.getLocalurl())).exists() || !(delete = file.delete())) continue;
                                VecDatabaseManager.getInstance().deletePathMessage(rtcSessionId, message);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        EMLog.e(VecChatManager.TAG, "\u5220\u9664\u79c1\u6709\u76ee\u5f55\u56fe\u7247/\u89c6\u9891/\u6587\u4ef6 \u5931\u8d25 error = " + e.getMessage());
                    }
                }
            });
        }
    }

    public static interface MessageListener {
        public void onMessage(List<Message> var1);

        public void onMessageSent();

        public void onNewChatMessageNotify();
    }
}

