/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.KefuDBManager;
import com.hyphenate.chat.Message;
import com.hyphenate.chat.VecDatabaseManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VecConversation {
    private static VecConversation sVecConversation;
    private final List<Message> messages = Collections.synchronizedList(new ArrayList());
    private final List<Message> tempMessages = Collections.synchronizedList(new ArrayList());
    private String mRtcSessionId;
    public boolean mIsOpen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VecConversation getInstance() {
        if (sVecConversation != null) return sVecConversation;
        Class<VecDatabaseManager> clazz = VecDatabaseManager.class;
        synchronized (VecDatabaseManager.class) {
            if (sVecConversation != null) return sVecConversation;
            sVecConversation = new VecConversation();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sVecConversation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(Message message) {
        if (!this.mIsOpen) {
            return;
        }
        this.check();
        List<Message> list = this.messages;
        synchronized (list) {
            if (this.messages.size() > 0) {
                Message previousMsg = this.messages.get(this.messages.size() - 1);
                if (message.messageId() != null && previousMsg.messageId() != null && message.messageId().equals(previousMsg.messageId())) {
                    return;
                }
            }
            boolean isAdded = false;
            for (Message msg : this.messages) {
                if (!msg.messageId().equals(message.messageId())) continue;
                isAdded = true;
                break;
            }
            if (!isAdded) {
                this.messages.add(message);
                Collections.sort(this.messages);
            }
        }
    }

    public List<Message> getAllMessages(int pageSize) {
        if (this.messages.size() == 0) {
            this.check();
            List<Message> list = VecDatabaseManager.getInstance().getMessages(this.mRtcSessionId, pageSize);
            this.messages.addAll(list);
        }
        return this.messages;
    }

    public List<Message> getAllMessages() {
        return this.messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageToList(List<Message> megs) {
        List<Message> list = this.messages;
        synchronized (list) {
            for (Message gs : megs) {
                boolean isHav = false;
                for (Message message : this.messages) {
                    if (!message.messageId().equals(gs.messageId())) continue;
                    isHav = true;
                    break;
                }
                if (isHav) continue;
                this.messages.add(gs);
            }
            Collections.sort(this.messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> loadMessages(Message startMsg, int pageSize) {
        List<Message> msgList;
        if (!this.mIsOpen) {
            return new ArrayList<Message>();
        }
        this.check();
        List<Message> list = this.messages;
        synchronized (list) {
            msgList = KefuDBManager.getInstance().findVecMessages(this.mRtcSessionId, startMsg, pageSize);
            if (msgList.size() > 0) {
                for (Message message : msgList) {
                    boolean isHav = false;
                    for (Message msg : this.messages) {
                        if (!message.messageId().equals(msg.messageId())) continue;
                        isHav = true;
                        break;
                    }
                    if (isHav) continue;
                    this.messages.add(message);
                }
                Collections.sort(this.messages);
            }
        }
        return msgList;
    }

    private void check() {
        if (!this.mIsOpen) {
            return;
        }
        this.mRtcSessionId = ChatClient.getInstance().vecChatManager().mRtcSessionId;
        if (TextUtils.isEmpty((CharSequence)this.mRtcSessionId)) {
            throw new RuntimeException("\u8bf7\u5148\u8c03\u7528ChatClient.getInstance().vecChatManager().bindVecChat()\u7ed1\u5b9a\u804a\u5929\u9875\u9762\uff01");
        }
    }

    public void clear() {
        this.mIsOpen = false;
        this.mRtcSessionId = null;
        this.messages.clear();
    }

    public Message getMessage(String msgId) {
        for (Message message : this.messages) {
            if (!message.messageId().equals(msgId)) continue;
            return message;
        }
        return null;
    }
}

