/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.ContentValues;
import com.hyphenate.chat.FilePathMessage;
import com.hyphenate.chat.KefuDBManager;
import com.hyphenate.chat.Message;
import com.hyphenate.util.EMLog;
import java.util.Hashtable;
import java.util.List;
import org.json.JSONObject;

public class VecDatabaseManager {
    private static final String TAG = "VecConversationManager";
    private Hashtable<String, Message> allMessages = new Hashtable();
    private static VecDatabaseManager sVecDatabaseManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VecDatabaseManager getInstance() {
        if (sVecDatabaseManager != null) return sVecDatabaseManager;
        Class<VecDatabaseManager> clazz = VecDatabaseManager.class;
        synchronized (VecDatabaseManager.class) {
            if (sVecDatabaseManager != null) return sVecDatabaseManager;
            sVecDatabaseManager = new VecDatabaseManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sVecDatabaseManager;
        }
    }

    public boolean saveMessage(String rtcSession, Message message) {
        EMLog.e(TAG, "save vec message:" + message.messageId());
        try {
            return KefuDBManager.getInstance().saveVecMessage(rtcSession, message);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    void updateMessageBodyContent(String rtcSession, Message message, JSONObject bodyJson) {
        try {
            KefuDBManager.getInstance().updateMessageBodyContent(rtcSession, message, bodyJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Message> getMessages(String rtcSessionId, int pageSize) {
        try {
            return KefuDBManager.getInstance().findVecMessages(rtcSessionId, pageSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void updateMessageState(String rtcSessionId, Message message) {
        ContentValues cvs = new ContentValues();
        cvs.put("status", Integer.valueOf(message.status().ordinal()));
        KefuDBManager.getInstance().updateVecMessage(rtcSessionId, message.messageId(), cvs);
    }

    public void updateMessageStateAndTime(String rtcSessionId, Message message) {
        ContentValues cvs = new ContentValues();
        cvs.put("status", Integer.valueOf(message.status().ordinal()));
        cvs.put("servertime", Long.valueOf(message.messageTime()));
        KefuDBManager.getInstance().updateVecMessage(rtcSessionId, message.messageId(), cvs);
    }

    boolean isMessageExistedByExtMsgId(String extMsgId, String serviceSessionId) {
        return KefuDBManager.getInstance().isVecMessageExistedByExtMsgId(extMsgId, serviceSessionId);
    }

    public void deleteMessage(String rtcSessionId, Message message) {
        KefuDBManager.getInstance().deleteVecMessage(rtcSessionId, message);
    }

    public void deleteVecAllMessage(String rtcSessionId) {
        KefuDBManager.getInstance().deleteVecAllMessage(rtcSessionId);
    }

    public void saveVecPathMessage(String rtcSession, Message message) {
        EMLog.e(TAG, "save vec path message:" + message.messageId());
        try {
            KefuDBManager.getInstance().saveVecPathMessage(rtcSession, message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<FilePathMessage> getVecPathMessage(String rtcSessionId, long theDateTime) {
        return KefuDBManager.getInstance().getVecPathMessage(rtcSessionId, theDateTime);
    }

    public void deletePathMessage(String rtcSessionId, FilePathMessage message) {
        KefuDBManager.getInstance().deletePathMessage(rtcSessionId, message);
    }
}

