/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.httpclient;

import com.hyphenate.helpdesk.httpclient.HttpClientException;
import com.hyphenate.helpdesk.httpclient.HttpResponse;
import com.hyphenate.helpdesk.httpclient.HttpResponseHandler;
import com.hyphenate.helpdesk.httpclient.IOUtils;
import com.hyphenate.helpdesk.httpclient.ProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class WriteToOutputStreamAndProgressHandler
extends HttpResponseHandler {
    private final OutputStream out;
    private final ProgressListener listener;

    public WriteToOutputStreamAndProgressHandler(OutputStream out, ProgressListener listener) {
        if (out == null) {
            throw new IllegalArgumentException("Output stream cannot be null");
        }
        this.out = out;
        this.listener = listener;
    }

    @Override
    public void onResponse(HttpResponse response, long contentLength) throws Exception {
        try {
            int bytesRead;
            InputStream in = response.getPayload();
            byte[] buf = new byte[1024];
            long totalReaded = 0L;
            while ((bytesRead = in.read(buf)) != -1) {
                if (contentLength > 0L) {
                    long progress = (totalReaded += (long)bytesRead) * 100L / contentLength;
                    this.listener.loadProgress(progress);
                }
                this.out.write(buf, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new HttpClientException("Cannot write Http response to output stream", e);
        }
        finally {
            IOUtils.close(this.out);
        }
    }
}

