/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.model;

import com.hyphenate.helpdesk.model.Content;
import com.hyphenate.helpdesk.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import org.json.JSONException;
import org.json.JSONObject;

public class RobotMenuInfo
extends Content {
    private static final String TAG = "RobotMenuInfo";
    public static final String PARENT_NAME = "msgtype";
    public static final String NAME = "choice";
    static final String NAME_ITEMS = "items";
    static final String NAME_LIST = "list";

    public RobotMenuInfo() {
    }

    public RobotMenuInfo(JSONObject jsonObj) {
        super(jsonObj);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getParentName() {
        return PARENT_NAME;
    }

    public String getTitle() {
        return this.get("title");
    }

    public Collection<Item> getItems() {
        Collection<JSONObject> objArray = this.getObjectArray(NAME_ITEMS);
        if (objArray == null) {
            return null;
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (JSONObject obj : objArray) {
            Item item = this.createItem(obj);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public Collection<String> getList() {
        return this.getStringArray(NAME_LIST);
    }

    private Item createItem(JSONObject obj) {
        Item item = null;
        try {
            item = new Item(obj.getString("id"), obj.getString("name"));
            item.setContent(obj);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            Log.e(TAG, ex.getMessage());
        }
        return item;
    }

    public class Item {
        private String id;
        private String name;
        private JSONObject jsonObj;

        Item(String id2, String name) {
            this.id = id2;
            this.name = name;
        }

        public void setContent(JSONObject jsonObj) {
            this.jsonObj = jsonObj;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.jsonObj.toString();
        }
    }
}

