/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.hyphenate.chat.PreferenceUtil;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;
import java.io.File;

public class AdapterFileUtils {
    private static final String TAG = AdapterFileUtils.class.getSimpleName();

    private static boolean isQ() {
        return Build.VERSION.SDK_INT >= 29;
    }

    public static boolean isFileExistByUri(Context context, Uri fileUri) {
        return EMFileHelper.getInstance().isFileExist(fileUri);
    }

    public static void deleteFile(Context context, Uri uri) {
        if (AdapterFileUtils.isFileExistByUri(context, uri)) {
            String filePath = AdapterFileUtils.getFilePath(context, uri);
            if (!TextUtils.isEmpty((CharSequence)filePath)) {
                File file = new File(filePath);
                if (file != null && file.exists() && file.isFile()) {
                    file.delete();
                }
            } else {
                try {
                    context.getContentResolver().delete(uri, null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getFileNameByUri(Context context, Uri fileUri) {
        return EMFileHelper.getInstance().getFilename(fileUri);
    }

    public static String getFilePath(Context context, Uri uri) {
        return EMFileHelper.getInstance().getFilePath(uri);
    }

    public static boolean uriStartWithFile(Uri fileUri) {
        return "file".equalsIgnoreCase(fileUri.getScheme()) && fileUri.toString().length() > 7;
    }

    public static boolean uriStartWithContent(Uri fileUri) {
        return "content".equalsIgnoreCase(fileUri.getScheme());
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isFileProvider(Context context, Uri uri) {
        return (context.getApplicationInfo().packageName + ".fileProvider").equalsIgnoreCase(uri.getAuthority());
    }

    public static boolean isOtherFileProvider(Context context, Uri uri) {
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        if (TextUtils.isEmpty((CharSequence)scheme) || TextUtils.isEmpty((CharSequence)authority)) {
            return false;
        }
        return !(context.getApplicationInfo().packageName + ".fileProvider").equalsIgnoreCase(uri.getAuthority()) && "content".equalsIgnoreCase(uri.getScheme()) && authority.contains(".fileProvider".toLowerCase());
    }

    @SuppressLint(value={"WrongConstant"})
    public static boolean saveUriPermission(Context context, Uri fileUri, Intent intent) {
        if (context == null || fileUri == null) {
            return false;
        }
        if (!AdapterFileUtils.uriStartWithContent(fileUri)) {
            return false;
        }
        int intentFlags = 0;
        if (intent != null) {
            intentFlags = intent.getFlags();
        }
        int takeFlags = intentFlags & 3;
        String last = null;
        try {
            if (Build.VERSION.SDK_INT >= 19) {
                context.getContentResolver().takePersistableUriPermission(fileUri, takeFlags);
            }
            last = AdapterFileUtils.getLastSubFromUri(fileUri);
            EMLog.d(TAG, "saveUriPermission last part of Uri: " + last);
        }
        catch (SecurityException e) {
            EMLog.e("EaseFileUtils", "saveUriPermission failed e: " + e.getMessage());
        }
        if (!TextUtils.isEmpty((CharSequence)last)) {
            PreferenceUtil.getInstance().putString(last, fileUri.toString());
            return true;
        }
        return false;
    }

    private static String getLastSubFromUri(Uri fileUri) {
        if (fileUri == null) {
            return "";
        }
        String uri = fileUri.toString();
        if (!uri.contains("/")) {
            return "";
        }
        int lastIndex = uri.lastIndexOf("/");
        return uri.substring(lastIndex + 1);
    }

    public static Uri takePersistableUriPermission(Context context, Uri uri) {
        String fileUri;
        if (context == null || uri == null) {
            return null;
        }
        if (!AdapterFileUtils.uriStartWithContent(uri)) {
            return null;
        }
        String last = AdapterFileUtils.getLastSubFromUri(uri);
        if (!TextUtils.isEmpty((CharSequence)last) && !TextUtils.isEmpty((CharSequence)(fileUri = PreferenceUtil.getInstance().getString(last)))) {
            try {
                if (Build.VERSION.SDK_INT >= 19) {
                    context.getContentResolver().takePersistableUriPermission(Uri.parse((String)fileUri), 1);
                }
                return Uri.parse((String)fileUri);
            }
            catch (SecurityException e) {
                EMLog.e("EaseFileUtils", "takePersistableUriPermission failed e: " + e.getMessage());
                return null;
            }
        }
        try {
            if (Build.VERSION.SDK_INT >= 19) {
                context.getContentResolver().takePersistableUriPermission(uri, 1);
            }
        }
        catch (SecurityException e) {
            EMLog.e("EaseFileUtils", "takePersistableUriPermission failed e: " + e.getMessage());
            return null;
        }
        return uri;
    }
}

