/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.DocumentsContract;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import java.io.File;

abstract class DocumentFile {
    static final String TAG = "DocumentFile";
    private final DocumentFile mParent;

    DocumentFile(DocumentFile parent) {
        this.mParent = parent;
    }

    public static DocumentFile fromFile(File file) {
        if (file == null) {
            return null;
        }
        return new RawDocumentFile(null, file);
    }

    public static DocumentFile fromSingleUri(Context context, Uri singleUri) {
        if (Build.VERSION.SDK_INT >= 19) {
            return new SingleDocumentFile(null, context, singleUri);
        }
        return null;
    }

    public static boolean isDocumentUri(Context context, Uri uri) {
        if (Build.VERSION.SDK_INT >= 19) {
            return DocumentsContract.isDocumentUri((Context)context, (Uri)uri);
        }
        return false;
    }

    public abstract Uri getUri();

    public abstract String getName();

    public abstract String getType();

    public DocumentFile getParentFile() {
        return this.mParent;
    }

    public abstract boolean isDirectory();

    public abstract boolean isFile();

    public abstract boolean isVirtual();

    public abstract long lastModified();

    public abstract long length();

    public abstract boolean canRead();

    public abstract boolean canWrite();

    public abstract boolean delete();

    public abstract boolean exists();

    static class RawDocumentFile
    extends DocumentFile {
        private File mFile;

        RawDocumentFile(DocumentFile parent, File file) {
            super(parent);
            this.mFile = file;
        }

        @Override
        public Uri getUri() {
            return Uri.fromFile((File)this.mFile);
        }

        @Override
        public String getName() {
            return this.mFile.getName();
        }

        @Override
        public String getType() {
            if (this.mFile.isDirectory()) {
                return null;
            }
            return RawDocumentFile.getTypeForName(this.mFile.getName());
        }

        @Override
        public boolean isDirectory() {
            return this.mFile.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.mFile.isFile();
        }

        @Override
        public boolean isVirtual() {
            return false;
        }

        @Override
        public long lastModified() {
            return this.mFile.lastModified();
        }

        @Override
        public long length() {
            return this.mFile.length();
        }

        @Override
        public boolean canRead() {
            return this.mFile.canRead();
        }

        @Override
        public boolean canWrite() {
            return this.mFile.canWrite();
        }

        @Override
        public boolean delete() {
            RawDocumentFile.deleteContents(this.mFile);
            return this.mFile.delete();
        }

        @Override
        public boolean exists() {
            return this.mFile.exists();
        }

        private static String getTypeForName(String name) {
            int n = name.lastIndexOf(46);
            if (n >= 0) {
                String string = name.substring(n + 1).toLowerCase();
                String string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string);
                if (string2 != null) {
                    return string2;
                }
            }
            return "application/octet-stream";
        }

        private static boolean deleteContents(File dir) {
            File[] fileArray = dir.listFiles();
            boolean bl = true;
            if (fileArray != null) {
                for (File file : fileArray) {
                    if (file.isDirectory()) {
                        bl &= RawDocumentFile.deleteContents(file);
                    }
                    if (file.delete()) continue;
                    Log.w((String)DocumentFile.TAG, (String)("Failed to delete " + file));
                    bl = false;
                }
            }
            return bl;
        }
    }

    static class SingleDocumentFile
    extends DocumentFile {
        private Context mContext;
        private Uri mUri;

        SingleDocumentFile(DocumentFile parent, Context context, Uri uri) {
            super(parent);
            this.mContext = context;
            this.mUri = uri;
        }

        @Override
        public Uri getUri() {
            return this.mUri;
        }

        @Override
        public String getName() {
            return DocumentsContractApi19.getName(this.mContext, this.mUri);
        }

        @Override
        public String getType() {
            return DocumentsContractApi19.getType(this.mContext, this.mUri);
        }

        @Override
        public boolean isDirectory() {
            return DocumentsContractApi19.isDirectory(this.mContext, this.mUri);
        }

        @Override
        public boolean isFile() {
            return DocumentsContractApi19.isFile(this.mContext, this.mUri);
        }

        @Override
        public boolean isVirtual() {
            return DocumentsContractApi19.isVirtual(this.mContext, this.mUri);
        }

        @Override
        public long lastModified() {
            return DocumentsContractApi19.lastModified(this.mContext, this.mUri);
        }

        @Override
        public long length() {
            return DocumentsContractApi19.length(this.mContext, this.mUri);
        }

        @Override
        public boolean canRead() {
            return DocumentsContractApi19.canRead(this.mContext, this.mUri);
        }

        @Override
        public boolean canWrite() {
            return DocumentsContractApi19.canWrite(this.mContext, this.mUri);
        }

        @Override
        public boolean delete() {
            try {
                return DocumentsContract.deleteDocument((ContentResolver)this.mContext.getContentResolver(), (Uri)this.mUri);
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public boolean exists() {
            return DocumentsContractApi19.exists(this.mContext, this.mUri);
        }
    }

    static class DocumentsContractApi19 {
        private static final String TAG = "DocumentFile";
        private static final int FLAG_VIRTUAL_DOCUMENT = 512;

        public static boolean isVirtual(Context context, Uri self) {
            if (!DocumentsContract.isDocumentUri((Context)context, (Uri)self)) {
                return false;
            }
            return (DocumentsContractApi19.getFlags(context, self) & 0x200L) != 0L;
        }

        public static String getName(Context context, Uri self) {
            return DocumentsContractApi19.queryForString(context, self, "_display_name", null);
        }

        private static String getRawType(Context context, Uri self) {
            return DocumentsContractApi19.queryForString(context, self, "mime_type", null);
        }

        public static String getType(Context context, Uri self) {
            String string = DocumentsContractApi19.getRawType(context, self);
            if ("vnd.android.document/directory".equals(string)) {
                return null;
            }
            return string;
        }

        public static long getFlags(Context context, Uri self) {
            return DocumentsContractApi19.queryForLong(context, self, "flags", 0L);
        }

        public static boolean isDirectory(Context context, Uri self) {
            return "vnd.android.document/directory".equals(DocumentsContractApi19.getRawType(context, self));
        }

        public static boolean isFile(Context context, Uri self) {
            String string = DocumentsContractApi19.getRawType(context, self);
            return !"vnd.android.document/directory".equals(string) && !TextUtils.isEmpty((CharSequence)string);
        }

        public static long lastModified(Context context, Uri self) {
            return DocumentsContractApi19.queryForLong(context, self, "last_modified", 0L);
        }

        public static long length(Context context, Uri self) {
            return DocumentsContractApi19.queryForLong(context, self, "_size", 0L);
        }

        public static boolean canRead(Context context, Uri self) {
            if (context.checkCallingOrSelfUriPermission(self, 1) != 0) {
                return false;
            }
            return !TextUtils.isEmpty((CharSequence)DocumentsContractApi19.getRawType(context, self));
        }

        public static boolean canWrite(Context context, Uri self) {
            if (context.checkCallingOrSelfUriPermission(self, 2) != 0) {
                return false;
            }
            String string = DocumentsContractApi19.getRawType(context, self);
            int n = DocumentsContractApi19.queryForInt(context, self, "flags", 0);
            if (TextUtils.isEmpty((CharSequence)string)) {
                return false;
            }
            if ((n & 4) != 0) {
                return true;
            }
            if ("vnd.android.document/directory".equals(string) && (n & 8) != 0) {
                return true;
            }
            return !TextUtils.isEmpty((CharSequence)string) && (n & 2) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean exists(Context context, Uri self) {
            boolean bl;
            ContentResolver contentResolver = context.getContentResolver();
            Cursor cursor = null;
            try {
                cursor = contentResolver.query(self, new String[]{"document_id"}, null, null, null);
                bl = cursor.getCount() > 0;
            }
            catch (Exception exception) {
                boolean bl2;
                try {
                    Log.w((String)"DocumentFile", (String)("Failed query: " + exception));
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    DocumentsContractApi19.closeQuietly(cursor);
                    throw throwable;
                }
                DocumentsContractApi19.closeQuietly((AutoCloseable)cursor);
                return bl2;
            }
            DocumentsContractApi19.closeQuietly((AutoCloseable)cursor);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String queryForString(Context context, Uri self, String column, String defaultValue) {
            String string;
            Cursor cursor;
            block5: {
                ContentResolver contentResolver = context.getContentResolver();
                cursor = null;
                cursor = contentResolver.query(self, new String[]{column}, null, null, null);
                if (!cursor.moveToFirst() || cursor.isNull(0)) break block5;
                String string2 = cursor.getString(0);
                DocumentsContractApi19.closeQuietly((AutoCloseable)cursor);
                return string2;
            }
            try {
                string = defaultValue;
            }
            catch (Exception exception) {
                String string3;
                try {
                    Log.w((String)"DocumentFile", (String)("Failed query: " + exception));
                    string3 = defaultValue;
                }
                catch (Throwable throwable) {
                    DocumentsContractApi19.closeQuietly(cursor);
                    throw throwable;
                }
                DocumentsContractApi19.closeQuietly((AutoCloseable)cursor);
                return string3;
            }
            DocumentsContractApi19.closeQuietly((AutoCloseable)cursor);
            return string;
        }

        private static int queryForInt(Context context, Uri self, String column, int defaultValue) {
            return (int)DocumentsContractApi19.queryForLong(context, self, column, defaultValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static long queryForLong(Context context, Uri self, String column, long defaultValue) {
            long l;
            Cursor cursor;
            block5: {
                ContentResolver contentResolver = context.getContentResolver();
                cursor = null;
                cursor = contentResolver.query(self, new String[]{column}, null, null, null);
                if (!cursor.moveToFirst() || cursor.isNull(0)) break block5;
                long l2 = cursor.getLong(0);
                DocumentsContractApi19.closeQuietly((AutoCloseable)cursor);
                return l2;
            }
            try {
                l = defaultValue;
            }
            catch (Exception exception) {
                long l3;
                try {
                    Log.w((String)"DocumentFile", (String)("Failed query: " + exception));
                    l3 = defaultValue;
                }
                catch (Throwable throwable) {
                    DocumentsContractApi19.closeQuietly(cursor);
                    throw throwable;
                }
                DocumentsContractApi19.closeQuietly((AutoCloseable)cursor);
                return l3;
            }
            DocumentsContractApi19.closeQuietly((AutoCloseable)cursor);
            return l;
        }

        private static void closeQuietly(AutoCloseable closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private DocumentsContractApi19() {
        }
    }
}

