/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.util.UriUtils;
import com.hyphenate.util.VersionUtils;
import java.io.File;

public class EMFileHelper {
    private Context mContext = EMClient.getInstance().getContext();
    private IFilePresenter mHelper = new FilePresenterImpl();

    private EMFileHelper() {
    }

    public static EMFileHelper getInstance() {
        return EMFileHelperInstance.instance;
    }

    public void setFileHelper(IFilePresenter presenter) {
        this.mHelper = presenter;
    }

    public boolean isFileExist(Uri fileUri) {
        return this.mHelper.isFileExist(this.mContext, fileUri);
    }

    public boolean isFileExist(String stringUri) {
        if (TextUtils.isEmpty((CharSequence)stringUri)) {
            return false;
        }
        return this.isFileExist(Uri.parse((String)stringUri));
    }

    public boolean isFileExist(Context context, Uri fileUri) {
        return this.mHelper.isFileExist(context, fileUri);
    }

    public boolean isFileExist(Context context, String stringUri) {
        if (TextUtils.isEmpty((CharSequence)stringUri)) {
            return false;
        }
        return this.isFileExist(context, Uri.parse((String)stringUri));
    }

    public String getFilename(Uri fileUri) {
        return this.mHelper.getFilename(this.mContext, fileUri);
    }

    public String getFilename(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return "";
        }
        return this.getFilename(Uri.parse((String)filePath));
    }

    public String getFilePath(Uri fileUri) {
        return this.mHelper.getFilePath(this.mContext, fileUri);
    }

    public String getFilePath(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return filePath;
        }
        return this.getFilePath(Uri.parse((String)filePath));
    }

    public String getFilePath(Context context, Uri fileUri) {
        return this.mHelper.getFilePath(context, fileUri);
    }

    public String getFilePath(Context context, String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return filePath;
        }
        return this.getFilePath(context, Uri.parse((String)filePath));
    }

    public long getFileLength(Uri fileUri) {
        if (fileUri == null) {
            return 0L;
        }
        return this.mHelper.getFileLength(this.mContext, fileUri);
    }

    public long getFileLength(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return 0L;
        }
        return this.getFileLength(Uri.parse((String)filePath));
    }

    public String getFileMimeType(Uri fileUri) {
        return this.mHelper.getFileMimeType(this.mContext, fileUri);
    }

    public boolean deletePrivateFile(String filePath) {
        File file;
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        if (!this.isFileExist(filePath)) {
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)(filePath = this.getFilePath(Uri.parse((String)filePath)))) && (file = new File(filePath)).exists()) {
            return file.delete();
        }
        return false;
    }

    public Uri formatInUri(Uri fileUri) {
        if (fileUri == null) {
            return null;
        }
        if (VersionUtils.isTargetQ(this.mContext) && UriUtils.uriStartWithContent(fileUri)) {
            return fileUri;
        }
        String string = this.getFilePath(fileUri);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            fileUri = Uri.parse((String)string);
        }
        return fileUri;
    }

    public Uri formatInUri(File file) {
        if (file == null) {
            return null;
        }
        return Uri.parse((String)file.getAbsolutePath());
    }

    public Uri formatInUri(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        return this.formatInUri(Uri.parse((String)filePath));
    }

    public String formatInUriToString(Uri uri) {
        if ((uri = this.formatInUri(uri)) == null) {
            return "";
        }
        return uri.toString();
    }

    public String formatInUriToString(File file) {
        Uri uri = this.formatInUri(file);
        if (uri == null) {
            return "";
        }
        return uri.toString();
    }

    public String formatInUriToString(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return "";
        }
        return this.formatInUriToString(Uri.parse((String)filePath));
    }

    public String formatOutLocalUrl(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return filePath;
        }
        String string = this.getFilePath(filePath);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return filePath;
    }

    public Uri formatOutUri(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        Uri uri = Uri.parse((String)filePath);
        if (VersionUtils.isTargetQ(this.mContext) && UriUtils.uriStartWithContent(uri)) {
            return uri;
        }
        String string = this.getFilePath(uri);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            uri = Uri.fromFile((File)new File(string));
        }
        return uri;
    }

    public String uriToString(Uri fileUri) {
        if (fileUri == null) {
            return "";
        }
        return fileUri.toString();
    }

    public static class FilePresenterImpl
    implements IFilePresenter {
        @Override
        public boolean isFileExist(Context context, Uri fileUri) {
            return UriUtils.isFileExistByUri(context, fileUri);
        }

        @Override
        public String getFilename(Context context, Uri fileUri) {
            return UriUtils.getFileNameByUri(context, fileUri);
        }

        @Override
        public String getFilePath(Context context, Uri fileUri) {
            return UriUtils.getFilePath(context, fileUri);
        }

        @Override
        public long getFileLength(Context context, Uri fileUri) {
            return UriUtils.getFileLength(context, fileUri);
        }

        @Override
        public String getFileMimeType(Context context, Uri fileUri) {
            return UriUtils.getMimeType(context, fileUri);
        }
    }

    public static interface IFilePresenter {
        public boolean isFileExist(Context var1, Uri var2);

        public String getFilename(Context var1, Uri var2);

        public String getFilePath(Context var1, Uri var2);

        public long getFileLength(Context var1, Uri var2);

        public String getFileMimeType(Context var1, Uri var2);
    }

    private static class EMFileHelperInstance {
        private static final EMFileHelper instance = new EMFileHelper();

        private EMFileHelperInstance() {
        }
    }
}

