/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.Context;
import java.text.DecimalFormat;

public class TextFormater {
    private static final int GB_SP_DIFF = 160;
    private static final int[] secPosvalueList = new int[]{1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086, 4390, 4558, 4684, 4925, 5249, 5600};
    private static final char[] firstLetter = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'w', 'x', 'y', 'z'};

    public static String getDataSize(long bytes) {
        DecimalFormat decimalFormat = new DecimalFormat("###.00");
        if (bytes < 0L) {
            return "error";
        }
        if (bytes < 1024L) {
            return bytes + "bytes";
        }
        if (bytes < 0x100000L) {
            return decimalFormat.format((float)bytes / 1024.0f) + "KB";
        }
        if (bytes < 0x40000000L) {
            return decimalFormat.format((float)bytes / 1024.0f / 1024.0f) + "MB";
        }
        return decimalFormat.format((float)bytes / 1024.0f / 1024.0f / 1024.0f) + "GB";
    }

    public static String getKBDataSize(long kb) {
        DecimalFormat decimalFormat = new DecimalFormat("###.00");
        if (kb < 1024L) {
            return kb + "KB";
        }
        if (kb < 0x100000L) {
            return decimalFormat.format((float)kb / 1024.0f) + "MB";
        }
        if (kb < 0x40000000L) {
            return decimalFormat.format((float)kb / 1024.0f / 1024.0f) + "GB";
        }
        return "error";
    }

    public static String formatStr(Context context, int resId, String str) {
        String string = context.getText(resId).toString();
        return String.format(string, str);
    }

    public static String getFirstLetter(String oriStr) {
        String string = oriStr.toLowerCase();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char[] cArray = new char[]{c};
            byte[] byArray = new String(cArray).getBytes();
            if (byArray[0] < 128 && byArray[0] > 0) {
                stringBuilder.append(cArray);
                continue;
            }
            stringBuilder.append(TextFormater.convert(byArray));
        }
        return stringBuilder.toString().substring(0, 1);
    }

    private static char convert(byte[] bytes) {
        char c = '-';
        int n = 0;
        int n2 = 0;
        while (n2 < bytes.length) {
            int n3 = n2++;
            bytes[n3] = (byte)(bytes[n3] - 160);
        }
        n = bytes[0] * 100 + bytes[1];
        for (n2 = 0; n2 < 23; ++n2) {
            if (n < secPosvalueList[n2] || n >= secPosvalueList[n2 + 1]) continue;
            c = firstLetter[n2];
            break;
        }
        return c;
    }
}

