//
//  HDAppID.h
//  HelpDeskLite
//
//  Created by houli on 2022/1/6.
//  Copyright © 2022 hyphenate. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM (NSInteger, HDCMDMessageCallType) {
    HDCMDMessageCallType_VisitorInitiates_AgentAnswer    = 0,    /**  访客发起座席应答  */
    HDCMDMessageCallType_Agent_SendVisitorCallback,              /**座席主动回呼确认访客是否有回应  */
    HDCMDMessageCallType_Agent_Cancel_CallBack,                  /**座席取消回呼  */
    HDCMDMessageCallType_Agent_SendVisitorCallback_Ticket        /**座席主动回呼 携带加入房间的参数  */
};

@interface HDKeyCenter : NSObject

/**
  声网 appid 访客端通过消息传过来
 */
@property (nonatomic, strong)  NSString * agoraAppid;

/**
 声网token 访客端通过消息传过来
 */
@property (nonatomic, strong) NSString * agoraToken;
/**
 声网channel 访客端通过消息传过来
 */
@property (nonatomic, strong) NSString * agoraChannel;
/**
 声网uid 访客端通过消息传过来
 */
@property (nonatomic, strong) NSString * agoraUid;
/**
 callid 访客端通过消息传过来
 */
@property (nonatomic, strong) NSString * callid;
/**
 屏幕分享id
 */
@property (nonatomic, strong) NSString * shareUid;
/**
 座席昵称
 */
@property (nonatomic, strong) NSString * agentNickName;
/**
 访客昵称
 */
@property (nonatomic, strong) NSString * visitorNickName;
/**
  邀请座席昵称
 */
@property (nonatomic, strong) NSString *  invitationAgentNickName;
/**
 vec 独立访客端 座席主动回呼字段 yes 是回呼 no 不是 默认 no
 */
@property (nonatomic, assign) BOOL isAgentCallBackReceive;

/**
 vec 独立访客端 座席主动取消回呼字段 yes 是取消回呼  no  不取消回呼
 */
@property (nonatomic, assign) BOOL isAgentCancelCallbackReceive;

/**
   只有座席回呼的时候 这个值才会有值
 */
@property (nonatomic, strong) NSString *  imServiceNum;
/**
    新增字段 视频接通 收到cmd消息类型
 */
@property (nonatomic, assign) HDCMDMessageCallType  callType ;


@end


