//
//  EMPresence.h
//  HyphenateChat
//
//  Created by lixiaoming on 2022/1/14.
//  Copyright © 2022 easemob.com. All rights reserved.
//

#import <Foundation/Foundation.h>

/*!
 *  \~chinese
 *  在线状态详情，包括当前在线设备使用的平台以及当前在线状态。
 *
 *  \~english
 * The presence details, including the platform used by the publisher's current online device and the current presence state.
 */
@interface EMPresenceStatusDetail : NSObject
/*!
 *  \~chinese
 *  发布者的当前在线设备使用的平台，包括"ios"、"android"、"linux"、"windows"和"webim"。
 *
 *  \~english
 * The platform used by the current online device of the publisher, which can be "ios", "android", "linux", "windows", or "webim".
 */
@property (nonatomic,strong) NSString* _Nonnull device;
/*!
 *  \~chinese
 *  当前在线状态，0为离线，1为在线。
 *
 *  \~english
 * The current presence state of the publisher.
 */
@property (nonatomic) NSInteger status;
@end

/*!
 *  \~chinese
 *  在线状态属性类，包含发布者的用户 ID、在线设备使用的平台、当前在线状态以及在线状态的扩展信息、更新时间和到期时间。
 *
 *  \~english
 *  The presence property class that contains presence properties, including the publisher's user ID and current presence state, and the platform used by the online device, as well as the presence's extension information, update time, and subscription expiration time.
 */
@interface EMPresence: NSObject
/*!
 *  \~chinese
 *  在线状态发布者的用户 ID。
 *
 *  \~english
 *  The user ID of the presence publisher.
 */
@property (nonatomic,strong) NSString*_Nonnull publisher;

/*!
 *  \~chinese
 *  该用户当前在线状态详情。
 *
 *  \~english
 * The details of the current presence state.
 */
@property (nonatomic,strong) NSArray<EMPresenceStatusDetail*>*_Nullable statusDetails;

/*!
 *  \~chinese
 *  在线状态描述信息，使用该字段设置自定义状态。
 *
 *  \~english
 *  The presence description information.
 */
@property (nonatomic) NSString*_Nullable statusDescription;

/*!
 *  \~chinese
 * 在线状态更新时间。该时间由服务器自动生成。
 *
 *  \~english
 *  The presence update time, which is generated by the server.
 */
@property (nonatomic) NSInteger lastTime;

/*!
 *  \~chinese
 *  在线状态订阅到期时间。
 *
 *  \~english
 *  The expiration time of the presence subscription.
 */
@property (nonatomic) NSInteger expirytime;
@end;

